/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.language.ExpressionDefinition;

public class XPathWithNamespaceBuilderFilterTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    public void testSendMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<person xmlns='http://acme.com/cheese' name='James' city='London'/>");
        this.resultEndpoint.assertIsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<person xmlns='http://acme.com/cheese'  name='Hiram' city='Tampa'/>");
        this.resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces ns = new Namespaces("c", "http://acme.com/cheese").add("xsd", "http://www.w3.org/2001/XMLSchema");
                this.from("direct:start").filter((ExpressionDefinition)ns.xpath("/c:person[@name='James']")).to("mock:result");
            }
        };
    }
}

