/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregator.MyCompletionProcessor;

public class AggregateForceCompletionOnStopTest
extends ContextTestSupport {
    public void testForceCompletionTrue() throws Exception {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test4", "id", (Object)"2");
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should not have completed yet", (int)0, (int)myCompletionProcessor.getAggregationCount());
        this.context.stop();
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should have completed", (int)2, (int)myCompletionProcessor.getAggregationCount());
    }

    public void testForceCompletionFalse() throws Exception {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test4", "id", (Object)"2");
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should not have completed yet", (int)0, (int)myCompletionProcessor.getAggregationCount());
        this.context.stop();
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should not have completed yet", (int)0, (int)myCompletionProcessor.getAggregationCount());
    }

    public void testStopRouteForceCompletionTrue() throws Exception {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionTrue", (Object)"test4", "id", (Object)"2");
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should not have completed yet", (int)0, (int)myCompletionProcessor.getAggregationCount());
        this.context.stopRoute("foo");
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should have completed", (int)2, (int)myCompletionProcessor.getAggregationCount());
    }

    public void testStopRouteForceCompletionFalse() throws Exception {
        MyCompletionProcessor myCompletionProcessor = (MyCompletionProcessor)this.context.getRegistry().lookupByNameAndType("myCompletionProcessor", MyCompletionProcessor.class);
        myCompletionProcessor.reset();
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.context.getShutdownStrategy().setTimeout(5L);
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:forceCompletionFalse", (Object)"test4", "id", (Object)"2");
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should not have completed yet", (int)0, (int)myCompletionProcessor.getAggregationCount());
        this.context.stopRoute("bar");
        AggregateForceCompletionOnStopTest.assertEquals((String)"aggregation should not have completed yet", (int)0, (int)myCompletionProcessor.getAggregationCount());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myCompletionProcessor", (Object)new MyCompletionProcessor());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:forceCompletionTrue").routeId("foo").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).forceCompletionOnStop().completionSize(10).delay(100L).process("myCompletionProcessor");
                this.from("direct:forceCompletionFalse").routeId("bar").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(10).delay(100L).process("myCompletionProcessor");
            }
        };
    }
}

