/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateSimpleExpressionIssueTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateSimpleExpressionIssueTest.class);
    private static final String DATA = "100,200,1,123456,2010-03-01T12:13:14,100,USD,Best Buy,5045,Santa Monica,CA,Type\n";
    private MyBean myBean = new MyBean();
    private AggStrategy aggStrategy = new AggStrategy();

    @Override
    protected void setUp() throws Exception {
        AggregateSimpleExpressionIssueTest.deleteDirectory("target/files");
        super.setUp();
    }

    public void testDummy() throws Exception {
    }

    public void xxxtestAggregateSimpleExpression() throws Exception {
        int files = 10;
        int rows = 100000;
        int batches = rows / 1000;
        int total = files + files * rows + files * batches;
        LOG.info("There are " + total + " exchanges");
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(total).create();
        LOG.info("Writing 10 files with 100000 rows in each file");
        for (int i = 0; i < files; ++i) {
            BufferedWriter out = IOHelper.buffered((Writer)new FileWriter(new File("target/files", "data" + i)));
            for (int j = 0; j < rows; ++j) {
                out.write(DATA);
            }
            ((Writer)out).close();
        }
        StopWatch watch = new StopWatch();
        this.context.startRoute("foo");
        LOG.info("Waiting to process all the files");
        boolean matches = notify.matches(3L, TimeUnit.MINUTES);
        LOG.info("Should process all files " + matches);
        LOG.info("Time taken " + watch.taken() + " ms");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)((SplitDefinition)((RouteDefinition)this.from("file:target/files").routeId("foo").noAutoStartup().log("Picked up ${file:name}")).split().tokenize("\n")).streaming().aggregate((Expression)this.constant(true), (AggregationStrategy)AggregateSimpleExpressionIssueTest.this.aggStrategy).completionSize((Expression)this.simple("1000")).completionTimeout((Expression)this.simple("500")).bean((Object)AggregateSimpleExpressionIssueTest.this.myBean)).end().end();
            }
        };
    }

    public static final class AggStrategy
    implements AggregationStrategy {
        private final int batchSize = 1000;

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            String str = (String)newExchange.getIn().getBody(String.class);
            if (oldExchange == null) {
                ArrayList<String> list = new ArrayList<String>(1000);
                list.add(str);
                newExchange.getIn().setBody(list);
                return newExchange;
            }
            List list = (List)oldExchange.getIn().getBody(List.class);
            list.add(str);
            return oldExchange;
        }
    }

    public static final class MyBean {
        private volatile int cnt;

        public void invoke(List<String> strList) {
            LOG.info("Batch " + ++this.cnt);
        }
    }
}

