/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class AggregatorTest
extends ContextTestSupport {
    protected int messageCount = 100;

    public void testSendingLotsOfMessagesGetAggregatedToTheLatestMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"message:" + this.messageCount});
        for (int i = 1; i <= this.messageCount; ++i) {
            String body = "message:" + i;
            this.template.sendBodyAndHeader("direct:start", (Object)body, "cheese", (Object)123);
        }
        resultEndpoint.assertIsSatisfied();
    }

    public void testOneMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("cheese", 123);
        headers.put("bar", "viper bar");
        this.template.sendBodyAndHeaders("direct:predicate", (Object)"test", headers);
        resultEndpoint.assertIsSatisfied();
    }

    public void testBatchTimeoutExpiry() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"message:1", "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
    }

    public void testAggregatorNotAtStart() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        ((ValueBuilder)resultEndpoint.message(0).header("visited")).isNotNull();
        this.template.sendBodyAndHeader("seda:header", (Object)"message:1", "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(1000L).to("mock:result");
                ((RouteDefinition)this.from("seda:header").setHeader("visited", (Expression)this.constant(true))).aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(1000L).to("mock:result");
                this.from("direct:predicate").aggregate((Expression)this.header("cheese"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(1000L).completionPredicate(this.header("cheese").isEqualTo((Object)123)).to("mock:result");
            }
        };
    }
}

