/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.support.ServiceSupport;

public class CustomAggregationStrategyServiceTest
extends ContextTestSupport {
    private MyCustomStrategy strategy = new MyCustomStrategy();

    public void testCustomAggregationStrategy() throws Exception {
        CustomAggregationStrategyServiceTest.assertTrue((String)"Should be started", (boolean)this.strategy.start);
        CustomAggregationStrategyServiceTest.assertFalse((String)"Should not be stopped", (boolean)this.strategy.stop);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "id", (Object)"1");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        CustomAggregationStrategyServiceTest.assertFalse((String)"Should not be started", (boolean)this.strategy.start);
        CustomAggregationStrategyServiceTest.assertTrue((String)"Should be stopped", (boolean)this.strategy.stop);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)this.from("direct:start").aggregate((AggregationStrategy)CustomAggregationStrategyServiceTest.this.strategy).header("id")).completionSize(3).to("mock:result");
            }
        };
    }

    public final class MyCustomStrategy
    extends ServiceSupport
    implements AggregationStrategy {
        public boolean stop;
        public boolean start;

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            return newExchange;
        }

        protected void doStart() throws Exception {
            this.start = true;
            this.stop = false;
        }

        protected void doStop() throws Exception {
            this.stop = true;
            this.start = false;
        }
    }
}

