/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AbstractListAggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class CustomListAggregationStrategyCompletionFromBatchConsumerTest
extends ContextTestSupport {
    public void testCustomAggregationStrategy() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/batch", (Object)"100", "CamelFileName", (Object)"1.txt");
        this.template.sendBodyAndHeader("file:target/batch", (Object)"150", "CamelFileName", (Object)"2.txt");
        this.template.sendBodyAndHeader("file:target/batch", (Object)"130", "CamelFileName", (Object)"3.txt");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        List numbers = (List)((Exchange)result.getExchanges().get(0)).getIn().getBody(List.class);
        CustomListAggregationStrategyCompletionFromBatchConsumerTest.assertNotNull((Object)numbers);
        CustomListAggregationStrategyCompletionFromBatchConsumerTest.assertEquals((Object)Integer.valueOf("100"), numbers.get(0));
        CustomListAggregationStrategyCompletionFromBatchConsumerTest.assertEquals((Object)Integer.valueOf("150"), numbers.get(1));
        CustomListAggregationStrategyCompletionFromBatchConsumerTest.assertEquals((Object)Integer.valueOf("130"), numbers.get(2));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)this.from("file:target/batch?sortBy=file:name").routeId("foo").noAutoStartup().aggregate((AggregationStrategy)new MyListOfNumbersStrategy()).constant((Object)true)).completionFromBatchConsumer().to("mock:result");
            }
        };
    }

    public final class MyListOfNumbersStrategy
    extends AbstractListAggregationStrategy<Integer> {
        public Integer getValue(Exchange exchange) {
            String s = (String)exchange.getIn().getBody(String.class);
            return Integer.valueOf(s);
        }
    }
}

