/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;

public class DistributedConcurrentPerCorrelationKeyTest
extends AbstractDistributedTest {
    private MemoryAggregationRepository sharedAggregationRepository = new MemoryAggregationRepository(true);
    private int size = 200;
    private final String uri = "direct:start";

    public void testAggregateConcurrentPerCorrelationKey() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(50);
        ArrayList<1> tasks = new ArrayList<1>();
        int i = 0;
        while (i < this.size) {
            final int id = i % 25;
            final int choice = i % 2;
            final int count = i++;
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (choice == 0) {
                        DistributedConcurrentPerCorrelationKeyTest.this.template.sendBodyAndHeader("direct:start", (Object)("" + count), "id", (Object)id);
                    } else {
                        DistributedConcurrentPerCorrelationKeyTest.this.template2.sendBodyAndHeader("direct:start", (Object)("" + count), "id", (Object)id);
                    }
                    return null;
                }
            });
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        service.invokeAll(tasks);
        service.shutdown();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        int contextCount = mock.getReceivedCounter();
        int context2Count = mock2.getReceivedCounter();
        DistributedConcurrentPerCorrelationKeyTest.assertEquals((int)25, (int)(contextCount + context2Count));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)DistributedConcurrentPerCorrelationKeyTest.this.sharedAggregationRepository).optimisticLocking().completionSize(8).to("mock:result");
            }
        };
    }
}

