/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointTryCatchFinallyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointTryCatchFinallyTest.assertEquals((String)"Bye World", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointTryCatchFinallyTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointTryCatchFinallyTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).doTry().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel?failFirstAttempts=1")).doCatch(Exception.class).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).doFinally().to("log:after")).to("mock:after")).transform((Expression)this.constant("Bye World"))).end().to("mock:result");
            }
        };
    }
}

