/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncOnExceptionFailureProcessorWithRedeliveryTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
            AsyncOnExceptionFailureProcessorWithRedeliveryTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = AsyncOnExceptionFailureProcessorWithRedeliveryTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            AsyncOnExceptionFailureProcessorWithRedeliveryTest.assertTrue((boolean)cause.getMessage().startsWith("Simulated error at attempt 1."));
        }
        this.assertMockEndpointsSatisfied();
        AsyncOnExceptionFailureProcessorWithRedeliveryTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncOnExceptionFailureProcessorWithRedeliveryTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel?failFirstAttempts=2")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("mock:error");
                ((RouteDefinition)this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"))).to("mock:result");
            }
        };
    }
}

