/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import junit.framework.TestCase;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;

public class AsyncRouteWithErrorTest
extends ContextTestSupport {
    private static String route = "";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        route = "";
    }

    public void testAsyncRouteWithError() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello");
            AsyncRouteWithErrorTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            AsyncRouteWithErrorTest.assertEquals((String)"Damn forced by unit test", (String)e.getCause().getMessage());
        }
        route = route + "A";
        this.assertMockEndpointsSatisfied();
        AsyncRouteWithErrorTest.assertEquals((String)"BA", (String)route);
    }

    public void testAsyncRouteWithTypeConverted() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello", String.class);
            AsyncRouteWithErrorTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AsyncRouteWithErrorTest.assertEquals((String)"Damn forced by unit test", (String)e.getCause().getMessage());
        }
        route = route + "A";
        this.assertMockEndpointsSatisfied();
        AsyncRouteWithErrorTest.assertEquals((String)"BA", (String)route);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ThreadsDefinition)((RouteDefinition)this.from("direct:start").transform((Expression)this.body().append((Object)" World"))).threads().to("mock:foo")).delay(100L).process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            route = route + "B";
            TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
            throw new IllegalArgumentException("Damn forced by unit test");
        }
    }
}

