/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;

public class AsyncTraceHandlerTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncTraceHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncTraceHandlerTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncTraceHandlerTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext contextLocal = super.createCamelContext();
        Tracer tracer = (Tracer)contextLocal.getDefaultTracer();
        tracer.setEnabled(true);
        tracer.getTraceHandlers().clear();
        tracer.getTraceHandlers().add(new MyTraceHandler());
        tracer.setTraceOutExchanges(true);
        return contextLocal;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncTraceHandlerTest.this.context.setTracing(Boolean.valueOf(true));
                AsyncTraceHandlerTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").tracing().to("log:before")).to("async:bye:camel")).id("async")).to("log:after")).to("mock:result");
            }
        };
    }

    private static class MyTraceHandler
    implements TraceEventHandler {
        private MyTraceHandler() {
        }

        public void traceExchange(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        }

        public Object traceExchangeIn(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
            if (node.getId().equals("async")) {
                beforeThreadName = Thread.currentThread().getName();
            }
            return null;
        }

        public void traceExchangeOut(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange, Object traceState) throws Exception {
            if (node.getId().equals("async")) {
                afterThreadName = Thread.currentThread().getName();
            }
        }
    }
}

