/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransformDefinition;

public class AdviceWithTypeTest
extends ContextTestSupport {
    public void testUnknownType() throws Exception {
        try {
            ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.weaveByType(SplitDefinition.class).replace().to("mock:xxx");
                }
            });
            AdviceWithTypeTest.fail((String)"Should hve thrown exception");
        }
        catch (IllegalArgumentException e) {
            AdviceWithTypeTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("There are no outputs which matches: SplitDefinition in the route"));
        }
    }

    public void testReplace() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveByType(LogDefinition.class).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRemove() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveByType(TransformDefinition.class).remove();
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testBefore() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveByType(ToDefinition.class).before().transform((Expression)this.constant("Bye World"));
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAfter() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.weaveByType(ToDefinition.class).after().transform((Expression)this.constant("Bye World"));
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        Object out = this.template.requestBody("direct:start", (Object)"World");
        AdviceWithTypeTest.assertEquals((Object)"Bye World", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").transform((Expression)this.simple("Hello ${body}"))).log("Got ${body}")).to("mock:result");
            }
        };
    }
}

