/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;

public class InterceptorStrategyNotOrderedTest
extends ContextTestSupport {
    public void testInterceptorStrategyNotOrdered() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("order", (Object)"foobar");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                InterceptorStrategyNotOrderedTest.this.context.addInterceptStrategy((InterceptStrategy)new FooInterceptStrategy());
                InterceptorStrategyNotOrderedTest.this.context.addInterceptStrategy((InterceptStrategy)new BarInterceptStrategy());
                this.from("direct:start").to("mock:result");
            }
        };
    }

    private static class BarInterceptStrategy
    implements InterceptStrategy {
        private BarInterceptStrategy() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, final Processor target, Processor nextTarget) throws Exception {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    String order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = order + "bar";
                    exchange.getIn().setHeader("order", (Object)order);
                    target.process(exchange);
                }
            };
            return answer;
        }
    }

    private static class FooInterceptStrategy
    implements InterceptStrategy {
        private FooInterceptStrategy() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, final Processor target, Processor nextTarget) throws Exception {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    String order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = order + "foo";
                    exchange.getIn().setHeader("order", (Object)order);
                    target.process(exchange);
                }
            };
            return answer;
        }
    }
}

