/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.spi.ExchangeFormatter;

public class DefaultErrorHandlerExchangeFormatterRefTest
extends ContextTestSupport {
    private static int invoked;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myExchangeFormatter", (Object)new MyExchangeFormatter());
        return jndi;
    }

    public void testRetryUntil() throws Exception {
        try {
            this.template.requestBody("direct:start", (Object)"Hello World");
            DefaultErrorHandlerExchangeFormatterRefTest.fail((String)"Expected the exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultErrorHandlerExchangeFormatterRefTest.assertEquals((int)1, (int)invoked);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().exchangeFormatterRef("myExchangeFormatter"));
                this.from("direct:start").process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyExchangeFormatter
    implements ExchangeFormatter {
        public String format(Exchange exchange) {
            invoked++;
            return "Exchange";
        }
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            throw new MyFunctionalException("Sorry you cannot do this");
        }
    }
}

