/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.IOException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyTechnicalException;

public class ErrorOccuredInOnExceptionRoute
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testErrorInOnException() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(MyTechnicalException.class).handled(true).to("mock:tech");
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(MyFunctionalException.class).handled(true).to("mock:onFunc")).throwException((Exception)new MyTechnicalException("Tech error"))).to("mock:doneFunc");
                this.from("direct:start").throwException((Exception)new MyFunctionalException("Func error"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:onFunc").expectedMessageCount(1);
        this.getMockEndpoint("mock:doneFunc").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testErrorInOnExceptionNotHandledSecondOnException() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IOException.class).to("mock:tech");
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(MyFunctionalException.class).handled(true).to("mock:onFunc")).throwException((Exception)new IOException("Cannot do this"))).to("mock:doneFunc");
                this.from("direct:start").throwException((Exception)new MyFunctionalException("Func error"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:onFunc").expectedMessageCount(1);
        this.getMockEndpoint("mock:doneFunc").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ErrorOccuredInOnExceptionRoute.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ErrorOccuredInOnExceptionRoute.assertIsInstanceOf(IOException.class, e.getCause());
            ErrorOccuredInOnExceptionRoute.assertEquals((String)"Cannot do this", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testErrorInOnExceptionNotHandled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(MyFunctionalException.class).handled(true).to("mock:onFunc")).throwException((Exception)new IOException("Cannot do this"))).to("mock:doneFunc");
                this.from("direct:start").throwException((Exception)new MyFunctionalException("Func error"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:onFunc").expectedMessageCount(1);
        this.getMockEndpoint("mock:doneFunc").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ErrorOccuredInOnExceptionRoute.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ErrorOccuredInOnExceptionRoute.assertIsInstanceOf(IOException.class, e.getCause());
            ErrorOccuredInOnExceptionRoute.assertEquals((String)"Cannot do this", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }
}

