/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class LoggingErrorHandlerOnExceptionTest
extends ContextTestSupport {
    public void testLoggingErrorHandler() throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:kaboom", (Object)"Hello World");
            LoggingErrorHandlerOnExceptionTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            LoggingErrorHandlerOnExceptionTest.assertEquals((String)"Kaboom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testLoggingErrorHandlerOnException() throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.template.sendBody("direct:damn", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                LoggingErrorHandlerOnExceptionTest.this.context.setTracing(Boolean.valueOf(true));
                this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler("org.apache.camel.MyLogger"));
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handled");
                ((RouteDefinition)this.from("direct:kaboom").to("log:kaboom")).throwException(new Exception("Kaboom"));
                ((RouteDefinition)this.from("direct:damn").to("log:damn")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

