/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionAndDLCErrorHandlerIssueTest
extends ContextTestSupport {
    public void testNoOnException() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testOnException() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((OnExceptionDefinition)this.from("direct:bar").routeId("bar").onException(IllegalArgumentException.class).handled(true).to("mock:handled")).end().to("mock:bar").throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

