/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyServiceBean;
import org.apache.camel.processor.onexception.MyTechnicalException;

public class OnExceptionComplexRouteTest
extends ContextTestSupport {
    protected MyServiceBean myServiceBean;

    public void testNoError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testNoError2() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start2", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testFunctionalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testFunctionalError2() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start2", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testTechnicalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech.error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testTechnicalError2() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech.error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start2", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        this.myServiceBean = new MyServiceBean();
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myServiceBean", (Object)this.myServiceBean);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).logStackTrace(false));
                this.onException(MyTechnicalException.class).handled(true).maximumRedeliveries(2).to("mock:tech.error");
                this.from("direct:start").onException(MyFunctionalException.class).maximumRedeliveries(0).end().to("bean:myServiceBean").to("mock:result");
                ((OnExceptionDefinition)this.from("direct:start2").onException(MyFunctionalException.class).handled(true).maximumRedeliveries(0).to("mock:handled")).end().to("bean:myServiceBean").to("mock:result");
            }
        };
    }
}

