/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Header;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.onexception.MyFunctionalException;

public class OnExceptionRetryUntilTest
extends ContextTestSupport {
    private static int invoked;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myRetryHandler", (Object)new MyRetryBean());
        return jndi;
    }

    public void testRetryUntil() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(1).redeliveryDelay(0L).logStackTrace(false));
                this.onException(MyFunctionalException.class).retryWhile((Predicate)this.method("myRetryHandler")).handled(true).transform().constant((Object)"Sorry");
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Sorry you cannot do this");
                    }
                });
            }
        });
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        OnExceptionRetryUntilTest.assertEquals((Object)"Sorry", (Object)out);
        OnExceptionRetryUntilTest.assertEquals((int)3, (int)invoked);
    }

    public class MyRetryBean {
        public boolean retry(@Header(value="CamelRedeliveryCounter") Integer counter, @Body String body, @ExchangeException Exception causedBy) {
            invoked++;
            TestCase.assertEquals((String)"Hello World", (String)body);
            TestCase.assertTrue((boolean)(causedBy instanceof MyFunctionalException));
            return counter < 3;
        }
    }
}

