/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.LinkedList;
import java.util.Random;
import org.apache.camel.TestSupport;
import org.apache.camel.processor.resequencer.IntegerComparator;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.ResequencerEngineSync;
import org.apache.camel.processor.resequencer.ResequencerRunner;
import org.apache.camel.processor.resequencer.SequenceBuffer;
import org.apache.camel.processor.resequencer.SequenceElementComparator;

public class ResequencerEngineTest
extends TestSupport {
    private static final boolean IGNORE_LOAD_TESTS = Boolean.parseBoolean(System.getProperty("ignore.load.tests", "true"));
    private ResequencerEngineSync<Integer> resequencer;
    private ResequencerRunner<Integer> runner;
    private SequenceBuffer<Integer> buffer;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        if (this.runner != null) {
            this.runner.cancel();
        }
        if (this.resequencer != null) {
            this.resequencer.stop();
        }
    }

    public void testTimeout1() throws Exception {
        this.initResequencer(500L, 10);
        this.resequencer.insert(4);
        ResequencerEngineTest.assertNull((Object)this.buffer.poll(250L));
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.buffer.take());
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.resequencer.getLastDelivered());
    }

    public void testTimeout2() throws Exception {
        this.initResequencer(500L, 10);
        this.resequencer.setLastDelivered(2);
        this.resequencer.insert(4);
        ResequencerEngineTest.assertNull((Object)this.buffer.poll(250L));
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.buffer.take());
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.resequencer.getLastDelivered());
    }

    public void testTimeout3() throws Exception {
        this.initResequencer(500L, 10);
        this.resequencer.setLastDelivered(3);
        this.resequencer.insert(4);
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.buffer.poll(250L));
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.resequencer.getLastDelivered());
    }

    public void testTimeout4() throws Exception {
        this.initResequencer(500L, 10);
        this.resequencer.setLastDelivered(2);
        this.resequencer.insert(4);
        this.resequencer.insert(3);
        ResequencerEngineTest.assertEquals((Object)3, (Object)this.buffer.poll(250L));
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.buffer.poll(250L));
        ResequencerEngineTest.assertEquals((Object)4, (Object)this.resequencer.getLastDelivered());
    }

    public void testRandom() throws Exception {
        int i;
        if (IGNORE_LOAD_TESTS) {
            return;
        }
        int input = 1000;
        this.initResequencer(1000L, 1000);
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i2 = 0; i2 < input; ++i2) {
            list.add(i2);
        }
        Random random = new Random(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder(4000);
        sb.append("Input sequence: ");
        long millis = System.currentTimeMillis();
        for (i = input; i > 0; --i) {
            int r = random.nextInt(i);
            int next = (Integer)list.remove(r);
            sb.append(next).append(" ");
            this.resequencer.insert(next);
        }
        this.log.info(sb.toString());
        sb.delete(0, sb.length());
        sb.append("Output sequence: ");
        for (i = 0; i < input; ++i) {
            sb.append(this.buffer.take()).append(" ");
        }
        millis = System.currentTimeMillis() - millis;
        this.log.info(sb.toString());
        this.log.info("Duration = " + millis + " ms");
    }

    public void testReverse1() throws Exception {
        if (IGNORE_LOAD_TESTS) {
            return;
        }
        this.testReverse(10);
    }

    public void testReverse2() throws Exception {
        if (IGNORE_LOAD_TESTS) {
            return;
        }
        this.testReverse(100);
    }

    private void testReverse(int capacity) throws Exception {
        this.initResequencer(1L, capacity);
        for (int i = 99; i >= 0; --i) {
            this.resequencer.insert(i);
        }
        StringBuilder sb = new StringBuilder(2500);
        sb.append("Output sequence: ");
        for (int i = 0; i < 100; ++i) {
            sb.append(this.buffer.take()).append(" ");
        }
        this.log.info(sb.toString());
    }

    private void initResequencer(long timeout, int capacity) {
        this.buffer = new SequenceBuffer();
        ResequencerEngine engine = new ResequencerEngine((SequenceElementComparator)new IntegerComparator());
        engine.setSequenceSender(this.buffer);
        engine.setTimeout(timeout);
        engine.start();
        this.resequencer = new ResequencerEngineSync(engine);
        this.runner = new ResequencerRunner<Integer>(this.resequencer, 50L);
        this.runner.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

