/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.MyBarSingleton;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.ModelHelper;

public class DumpModelAsXmlRoutePredicateTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myCoolBean", (Object)new MyBarSingleton());
        return jndi;
    }

    public void testDumpModelAsXml() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        DumpModelAsXmlRoutePredicateTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRoutePredicateTest.assertTrue((boolean)xml.contains("<simple>${body} &gt; 10</simple>"));
    }

    public void testDumpModelAsXmlXPath() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myOtherRoute"));
        DumpModelAsXmlRoutePredicateTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRoutePredicateTest.assertTrue((boolean)xml.contains("<xpath>/foo</xpath>"));
    }

    public void testDumpModelAsXmlHeader() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myFooRoute"));
        DumpModelAsXmlRoutePredicateTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRoutePredicateTest.assertTrue((boolean)xml.contains("<header>bar</header>"));
    }

    public void testDumpModelAsXmlBean() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myBeanRoute"));
        DumpModelAsXmlRoutePredicateTest.assertNotNull((Object)xml);
        this.log.info(xml);
        DumpModelAsXmlRoutePredicateTest.assertTrue((boolean)xml.contains("<method>myCoolBean</method>"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("myRoute").filter((Predicate)this.simple("${body} > 10")).to("mock:result");
                this.from("direct:other").routeId("myOtherRoute").filter((Predicate)this.xpath("/foo")).to("mock:result");
                ((FilterDefinition)this.from("direct:foo").routeId("myFooRoute").filter().header("bar")).to("mock:result");
                ((FilterDefinition)this.from("direct:bean").routeId("myBeanRoute").filter().method("myCoolBean")).to("mock:result");
            }
        };
    }
}

