/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ResourceHelper;

public class ResourceHelperTest
extends TestSupport {
    public void testLoadFile() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"file:src/test/resources/log4j.properties");
        ResourceHelperTest.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        is.close();
        context.stop();
    }

    public void testLoadFileWithSpace() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        ResourceHelperTest.createDirectory("target/my space");
        FileUtil.copyFile((File)new File("src/test/resources/log4j.properties"), (File)new File("target/my space/log4j.properties"));
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"file:target/my%20space/log4j.properties");
        ResourceHelperTest.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        is.close();
        context.stop();
    }

    public void testLoadClasspath() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"classpath:log4j.properties");
        ResourceHelperTest.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        is.close();
        context.stop();
    }

    public void testLoadRegistry() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"myBean", (Object)"This is a log4j logging configuation file");
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"ref:myBean");
        ResourceHelperTest.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        is.close();
        context.stop();
    }

    public void testLoadClasspathDefault() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"log4j.properties");
        ResourceHelperTest.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        is.close();
        context.stop();
    }

    public void testLoadFileNotFound() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        try {
            ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"file:src/test/resources/notfound.txt");
            ResourceHelperTest.fail((String)"Should not find file");
        }
        catch (FileNotFoundException e) {
            ResourceHelperTest.assertTrue((boolean)e.getMessage().contains("notfound.txt"));
        }
        context.stop();
    }

    public void testLoadClasspathNotFound() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        try {
            ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"classpath:notfound.txt");
            ResourceHelperTest.fail((String)"Should not find file");
        }
        catch (FileNotFoundException e) {
            ResourceHelperTest.assertEquals((String)"Cannot find resource: classpath:notfound.txt in classpath for URI: classpath:notfound.txt", (String)e.getMessage());
        }
        context.stop();
    }

    public void testLoadFileAsUrl() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        URL url = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)context.getClassResolver(), (String)"file:src/test/resources/log4j.properties");
        ResourceHelperTest.assertNotNull((Object)url);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)url);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        context.stop();
    }

    public void testLoadClasspathAsUrl() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        URL url = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)context.getClassResolver(), (String)"classpath:log4j.properties");
        ResourceHelperTest.assertNotNull((Object)url);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)url);
        ResourceHelperTest.assertNotNull((Object)text);
        ResourceHelperTest.assertTrue((boolean)text.contains("log4j"));
        context.stop();
    }

    public void testIsHttp() throws Exception {
        ResourceHelperTest.assertFalse((boolean)ResourceHelper.isHttpUri((String)"direct:foo"));
        ResourceHelperTest.assertFalse((boolean)ResourceHelper.isHttpUri((String)""));
        ResourceHelperTest.assertFalse((boolean)ResourceHelper.isHttpUri(null));
        ResourceHelperTest.assertTrue((boolean)ResourceHelper.isHttpUri((String)"http://camel.apache.org"));
        ResourceHelperTest.assertTrue((boolean)ResourceHelper.isHttpUri((String)"https://camel.apache.org"));
    }

    public void testGetScheme() throws Exception {
        ResourceHelperTest.assertEquals((String)"file:", (String)ResourceHelper.getScheme((String)"file:myfile.txt"));
        ResourceHelperTest.assertEquals((String)"classpath:", (String)ResourceHelper.getScheme((String)"classpath:myfile.txt"));
        ResourceHelperTest.assertEquals((String)"http:", (String)ResourceHelper.getScheme((String)"http:www.foo.com"));
        ResourceHelperTest.assertEquals(null, (String)ResourceHelper.getScheme((String)"www.foo.com"));
        ResourceHelperTest.assertEquals(null, (String)ResourceHelper.getScheme((String)"myfile.txt"));
    }

    public void testAppendParameters() throws Exception {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("foo", 123);
        params.put("bar", "yes");
        ResourceHelperTest.assertEquals((String)"http://localhost:8080/data?foo=123&bar=yes", (String)ResourceHelper.appendParameters((String)"http://localhost:8080/data", params));
        ResourceHelperTest.assertEquals((int)0, (int)params.size());
    }
}

