/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.com.github.benmanes.caffeine.cache.CacheLoader;
import org.apache.camel.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.camel.com.github.benmanes.caffeine.cache.LocalCache;
import org.apache.camel.com.github.benmanes.caffeine.cache.LocalManualCache;

interface LocalLoadingCache<C extends LocalCache<K, V>, K, V>
extends LocalManualCache<C, K, V>,
LoadingCache<K, V> {
    public static final Logger logger = Logger.getLogger(LocalLoadingCache.class.getName());

    public CacheLoader<? super K, V> cacheLoader();

    public Function<K, V> mappingFunction();

    public boolean hasBulkLoader();

    default public boolean hasLoadAll(CacheLoader<? super K, V> loader) {
        try {
            Method classLoadAll = loader.getClass().getMethod("loadAll", Iterable.class);
            Method defaultLoadAll = CacheLoader.class.getMethod("loadAll", Iterable.class);
            return !classLoadAll.equals(defaultLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e);
            return false;
        }
    }

    @Override
    default public V get(K key) {
        return this.cache().computeIfAbsent(key, this.mappingFunction());
    }

    @Override
    default public Map<K, V> getAll(Iterable<? extends K> keys) {
        return this.hasBulkLoader() ? this.loadInBulk(keys) : this.loadSequentially(keys);
    }

    default public Map<K, V> loadSequentially(Iterable<? extends K> keys) {
        int count = 0;
        HashMap<K, V> result = new HashMap<K, V>();
        Iterator<K> iter = keys.iterator();
        while (iter.hasNext()) {
            K key = iter.next();
            ++count;
            try {
                V value = this.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            catch (Throwable t) {
                int remaining;
                if (keys instanceof Collection) {
                    remaining = ((Collection)keys).size() - count;
                } else {
                    remaining = 0;
                    while (iter.hasNext()) {
                        ++remaining;
                        iter.next();
                    }
                }
                this.cache().statsCounter().recordMisses(remaining);
                throw t;
            }
        }
        return Collections.unmodifiableMap(result);
    }

    default public Map<K, V> loadInBulk(Iterable<? extends K> keys) {
        Map found = this.cache().getAllPresent(keys);
        HashSet<K> keysToLoad = new HashSet<K>();
        for (K key : keys) {
            if (found.containsKey(key)) continue;
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return found;
        }
        HashMap result = new HashMap(found);
        this.bulkLoad(keysToLoad, result);
        return Collections.unmodifiableMap(result);
    }

    default public void bulkLoad(Set<K> keysToLoad, Map<K, V> result) {
        boolean success = false;
        long startTime = this.cache().statsTicker().read();
        try {
            Map<Object, Object> loaded = this.cacheLoader().loadAll(keysToLoad);
            loaded.forEach((key, value) -> {
                this.cache().put((Object)key, (Object)value, false);
                if (keysToLoad.contains(key)) {
                    result.put(key, value);
                }
            });
            success = !loaded.isEmpty();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
        finally {
            long loadTime = this.cache().statsTicker().read() - startTime;
            if (success) {
                this.cache().statsCounter().recordLoadSuccess(loadTime);
            } else {
                this.cache().statsCounter().recordLoadFailure(loadTime);
            }
        }
    }

    @Override
    default public void refresh(K key) {
        Objects.requireNonNull(key);
        this.cache().executor().execute(() -> {
            BiFunction<Object, Object, Object> refreshFunction = (k, oldValue) -> {
                try {
                    return oldValue == null ? this.cacheLoader().load(key) : this.cacheLoader().reload(key, oldValue);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return LocalCache.throwUnchecked(e);
                }
                catch (Exception e) {
                    return LocalCache.throwUnchecked(e);
                }
            };
            try {
                this.cache().compute(key, refreshFunction, false, false);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception thrown during refresh", t);
            }
        });
    }
}

