/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperations
implements GenericFileOperations<File> {
    private static final Logger LOG = LoggerFactory.getLogger(FileOperations.class);
    private FileEndpoint endpoint;

    public FileOperations() {
    }

    public FileOperations(FileEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setEndpoint(GenericFileEndpoint<File> endpoint) {
        this.endpoint = (FileEndpoint)endpoint;
    }

    @Override
    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return FileUtil.deleteFile(file);
    }

    @Override
    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        boolean renamed = false;
        File file = new File(from);
        File target = new File(to);
        try {
            renamed = this.endpoint.isRenameUsingCopy() ? FileUtil.renameFileUsingCopy(file, target) : FileUtil.renameFile(file, target, this.endpoint.isCopyAndDeleteOnRenameFail());
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Error renaming file from " + from + " to " + to, e);
        }
        return renamed;
    }

    @Override
    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return file.exists();
    }

    protected boolean buildDirectory(File dir, Set<PosixFilePermission> permissions) {
        if (dir.exists()) {
            return true;
        }
        if (permissions == null || permissions.isEmpty()) {
            return dir.mkdirs();
        }
        try {
            String[] parts = dir.getPath().split("\\" + File.separatorChar);
            File base = new File(".");
            for (String part : parts) {
                File subDir = new File(base, part);
                if (!subDir.exists()) {
                    if (subDir.mkdir()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Setting chmod: {} on directory: {} ", (Object)PosixFilePermissions.toString(permissions), (Object)subDir);
                        }
                        Files.setPosixFilePermissions(subDir.toPath(), permissions);
                    } else {
                        return false;
                    }
                }
                base = new File(base, subDir.getName());
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Error setting chmod on directory: " + dir, e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        String afterRoot;
        ObjectHelper.notNull(this.endpoint, "endpoint");
        if (this.endpoint.isAutoCreate() && !this.endpoint.getFile().exists()) {
            LOG.trace("Building starting directory: {}", (Object)this.endpoint.getFile());
            this.buildDirectory(this.endpoint.getFile(), this.endpoint.getDirectoryPermissions());
        }
        if (ObjectHelper.isEmpty(directory)) {
            return true;
        }
        File endpointPath = this.endpoint.getFile();
        File target = new File(directory);
        File path = absolute ? target : (endpointPath.equals(target) ? endpointPath : (ObjectHelper.isNotEmpty(afterRoot = ObjectHelper.after(directory, endpointPath.getPath() + File.separator)) ? new File(this.endpoint.getFile(), afterRoot) : new File(this.endpoint.getFile(), directory)));
        FileOperations fileOperations = this;
        synchronized (fileOperations) {
            if (path.isDirectory() && path.exists()) {
                return true;
            }
            LOG.trace("Building directory: {}", (Object)path);
            return this.buildDirectory(path, this.endpoint.getDirectoryPermissions());
        }
    }

    @Override
    public List<File> listFiles() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public List<File> listFiles(String path) throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
    }

    @Override
    public void changeToParentDirectory() throws GenericFileOperationFailedException {
    }

    @Override
    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        return true;
    }

    @Override
    public void releaseRetreivedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
    }

    @Override
    public boolean storeFile(String fileName, Exchange exchange) throws GenericFileOperationFailedException {
        ObjectHelper.notNull(this.endpoint, "endpoint");
        File file = new File(fileName);
        if (file.exists()) {
            if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)file);
                return true;
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + file + ". Cannot write new file.");
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.doMoveExistingFile(fileName);
            }
        }
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                LOG.trace("Writing empty file.");
                try {
                    this.writeFileEmptyBody(file);
                    return true;
                }
                catch (IOException e) {
                    throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
                }
            }
            throw new GenericFileOperationFailedException("Cannot write null body to file: " + file);
        }
        try {
            Set<PosixFilePermission> permissions;
            Closeable in;
            String charset = this.endpoint.getCharset();
            File source = null;
            boolean fileBased = false;
            if (charset == null) {
                Object body = exchange.getIn().getBody();
                if (body instanceof WrappedFile) {
                    body = ((WrappedFile)body).getFile();
                }
                if (body instanceof File) {
                    source = (File)body;
                    fileBased = true;
                }
            }
            if (fileBased) {
                File local = exchange.getIn().getHeader("CamelFileLocalWorkPath", File.class);
                if (local != null && local.exists()) {
                    boolean renamed = this.writeFileByLocalWorkPath(local, file);
                    if (renamed) {
                        Set<PosixFilePermission> permissions2;
                        this.keepLastModified(exchange, file);
                        if (ObjectHelper.isNotEmpty(this.endpoint.getChmod()) && !(permissions2 = this.endpoint.getPermissions()).isEmpty()) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Setting chmod: {} on file: {} ", (Object)PosixFilePermissions.toString(permissions2), (Object)file);
                            }
                            Files.setPosixFilePermissions(file.toPath(), permissions2);
                        }
                        exchange.getIn().setHeader("CamelFileLocalWorkPath", null);
                        return true;
                    }
                } else if (source != null && source.exists()) {
                    Set<PosixFilePermission> permissions3;
                    this.writeFileByFile(source, file);
                    this.keepLastModified(exchange, file);
                    if (ObjectHelper.isNotEmpty(this.endpoint.getChmod()) && !(permissions3 = this.endpoint.getPermissions()).isEmpty()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Setting chmod: {} on file: {} ", (Object)PosixFilePermissions.toString(permissions3), (Object)file);
                        }
                        Files.setPosixFilePermissions(file.toPath(), permissions3);
                    }
                    return true;
                }
            }
            if (charset != null) {
                in = exchange.getContext().getTypeConverter().tryConvertTo(Reader.class, exchange, exchange.getIn().getBody());
                if (in == null) {
                    InputStream is = exchange.getIn().getMandatoryBody(InputStream.class);
                    in = new InputStreamReader(is);
                }
                in = IOHelper.buffered((Reader)in);
                this.writeFileByReaderWithCharset((Reader)in, file, charset);
            } else {
                in = exchange.getIn().getMandatoryBody(InputStream.class);
                this.writeFileByStream((InputStream)in, file);
            }
            this.keepLastModified(exchange, file);
            if (ObjectHelper.isNotEmpty(this.endpoint.getChmod()) && !(permissions = this.endpoint.getPermissions()).isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Setting chmod: {} on file: {} ", (Object)PosixFilePermissions.toString(permissions), (Object)file);
                }
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            return true;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
    }

    private void doMoveExistingFile(String fileName) throws GenericFileOperationFailedException {
        Exchange dummy = this.endpoint.createExchange();
        String parent = FileUtil.onlyPath(fileName);
        String onlyName = FileUtil.stripPath(fileName);
        dummy.getIn().setHeader("CamelFileName", fileName);
        dummy.getIn().setHeader("CamelFileNameOnly", onlyName);
        dummy.getIn().setHeader("CamelFileParent", parent);
        String to = this.endpoint.getMoveExisting().evaluate(dummy, String.class);
        to = FileUtil.normalizePath(to);
        if (ObjectHelper.isEmpty(to)) {
            throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
        }
        File toFile = new File(to);
        String directory = toFile.getParent();
        boolean absolute = FileUtil.isAbsolute(toFile);
        if (directory != null && !this.buildDirectory(directory, absolute)) {
            LOG.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
        }
        if (this.existsFile(to)) {
            if (this.endpoint.isEagerDeleteTargetFile()) {
                LOG.trace("Deleting existing file: {}", (Object)to);
                if (!this.deleteFile(to)) {
                    throw new GenericFileOperationFailedException("Cannot delete file: " + to);
                }
            } else {
                throw new GenericFileOperationFailedException("Cannot moved existing file from: " + fileName + " to: " + to + " as there already exists a file: " + to);
            }
        }
        LOG.trace("Moving existing file: {} to: {}", (Object)fileName, (Object)to);
        if (!this.renameFile(fileName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + to);
        }
    }

    private void keepLastModified(Exchange exchange, File file) {
        Date date;
        Long last;
        if (this.endpoint.isKeepLastModified() && (last = (date = exchange.getIn().getHeader("CamelFileLastModified", Date.class)) != null ? Long.valueOf(date.getTime()) : exchange.getIn().getHeader("CamelFileLastModified", Long.class)) != null) {
            boolean result = file.setLastModified(last);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Keeping last modified timestamp: {} on file: {} with result: {}", new Object[]{last, file, result});
            }
        }
    }

    private boolean writeFileByLocalWorkPath(File source, File file) throws IOException {
        LOG.trace("Using local work file being renamed from: {} to: {}", (Object)source, (Object)file);
        return FileUtil.renameFile(source, file, this.endpoint.isCopyAndDeleteOnRenameFail());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByFile(File source, File target) throws IOException {
        FileChannel in = new FileInputStream(source).getChannel();
        FileChannel out = null;
        try {
            out = this.prepareOutputFileChannel(target);
            LOG.debug("Using FileChannel to write file: {}", (Object)target);
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, this.endpoint.getBufferSize(), out)) {
            }
        }
        finally {
            IOHelper.close((Closeable)in, source.getName(), LOG);
            IOHelper.close(out, target.getName(), LOG, this.endpoint.isForceWrites());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByStream(InputStream in, File target) throws IOException {
        FileChannel out = null;
        try {
            int bytesRead;
            out = this.prepareOutputFileChannel(target);
            LOG.debug("Using InputStream to write file: {}", (Object)target);
            int size = this.endpoint.getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((bytesRead = in.read(buffer)) != -1) {
                if (bytesRead < size) {
                    byteBuffer.limit(bytesRead);
                }
                out.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            IOHelper.close((Closeable)in, target.getName(), LOG);
            IOHelper.close(out, target.getName(), LOG, this.endpoint.isForceWrites());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByReaderWithCharset(Reader in, File target, String charset) throws IOException {
        boolean append = this.endpoint.getFileExist() == GenericFileExist.Append;
        FileOutputStream os = new FileOutputStream(target, append);
        BufferedWriter out = IOConverter.toWriter(os, charset);
        try {
            LOG.debug("Using Reader to write file: {} with charset: {}", (Object)target, (Object)charset);
            int size = this.endpoint.getBufferSize();
            IOHelper.copy(in, out, size);
        }
        finally {
            IOHelper.close((Closeable)in, target.getName(), LOG);
            IOHelper.close(out, os, target.getName(), LOG, this.endpoint.isForceWrites());
        }
    }

    private void writeFileEmptyBody(File target) throws IOException {
        if (!target.exists()) {
            LOG.debug("Creating new empty file: {}", (Object)target);
            FileUtil.createNewFile(target);
        } else if (this.endpoint.getFileExist() == GenericFileExist.Override) {
            LOG.debug("Truncating existing file: {}", (Object)target);
            FileChannel out = new FileOutputStream(target).getChannel();
            try {
                out.truncate(0L);
            }
            finally {
                IOHelper.close(out, target.getName(), LOG, this.endpoint.isForceWrites());
            }
        }
    }

    private FileChannel prepareOutputFileChannel(File target) throws IOException {
        if (this.endpoint.getFileExist() == GenericFileExist.Append) {
            FileChannel out = new RandomAccessFile(target, "rw").getChannel();
            return out.position(out.size());
        }
        return new FileOutputStream(target).getChannel();
    }
}

