/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuilderSupport {
    private ModelCamelContext context;
    private ErrorHandlerBuilder errorHandlerBuilder;

    protected BuilderSupport() {
    }

    protected BuilderSupport(CamelContext context) {
        this.context = context != null ? context.adapt(ModelCamelContext.class) : null;
    }

    public ValueBuilder header(String name) {
        HeaderExpression exp = new HeaderExpression(name);
        return new ValueBuilder(exp);
    }

    @Deprecated
    public ValueBuilder property(String name) {
        ExchangePropertyExpression exp = new ExchangePropertyExpression(name);
        return new ValueBuilder(exp);
    }

    public ValueBuilder exchangeProperty(String name) {
        ExchangePropertyExpression exp = new ExchangePropertyExpression(name);
        return new ValueBuilder(exp);
    }

    public ValueBuilder body() {
        return Builder.body();
    }

    @Deprecated
    public <T> ValueBuilder body(Class<T> type) {
        return this.bodyAs(type);
    }

    public <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    @Deprecated
    public ValueBuilder outBody() {
        return Builder.outBody();
    }

    @Deprecated
    public <T> ValueBuilder outBody(Class<T> type) {
        return Builder.outBodyAs(type);
    }

    public ValueBuilder faultBody() {
        return Builder.faultBody();
    }

    @Deprecated
    public <T> ValueBuilder faultBodyAs(Class<T> type) {
        return Builder.faultBodyAs(type);
    }

    public ValueBuilder systemProperty(String name) {
        return Builder.systemProperty(name);
    }

    public ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty(name, defaultValue);
    }

    public ValueBuilder constant(Object value) {
        return Builder.constant(value);
    }

    public ValueBuilder language(String language, String expression) {
        return Builder.language(language, expression);
    }

    public SimpleBuilder simple(String value) {
        return SimpleBuilder.simple(value);
    }

    public SimpleBuilder simple(String value, Class<?> resultType) {
        return SimpleBuilder.simple(value, resultType);
    }

    public SimpleBuilder simpleF(String format, Object ... values) {
        return SimpleBuilder.simpleF(format, values);
    }

    public SimpleBuilder simpleF(String format, Class<?> resultType, Object ... values) {
        return SimpleBuilder.simpleF(format, resultType, values);
    }

    public XPathBuilder xpath(String value) {
        return XPathBuilder.xpath(value);
    }

    public static XPathBuilder xpath(String value, Class<?> resultType) {
        return XPathBuilder.xpath(value, resultType);
    }

    @Deprecated
    public ValueBuilder bean(Object beanOrBeanRef) {
        return this.bean(beanOrBeanRef, null);
    }

    @Deprecated
    public ValueBuilder bean(Object beanOrBeanRef, String method) {
        return Builder.bean(beanOrBeanRef, method);
    }

    @Deprecated
    public ValueBuilder bean(Class<?> beanType) {
        return Builder.bean(beanType);
    }

    @Deprecated
    public ValueBuilder bean(Class<?> beanType, String method) {
        return Builder.bean(beanType, method);
    }

    public ValueBuilder method(Object beanOrBeanRef) {
        return this.method(beanOrBeanRef, null);
    }

    public ValueBuilder method(Object beanOrBeanRef, String method) {
        return Builder.bean(beanOrBeanRef, method);
    }

    public ValueBuilder method(Class<?> beanType) {
        return Builder.bean(beanType);
    }

    public ValueBuilder method(Class<?> beanType, String method) {
        return Builder.bean(beanType, method);
    }

    @Deprecated
    public ValueBuilder sendTo(String uri) {
        return Builder.sendTo(uri);
    }

    public ValueBuilder regexReplaceAll(Expression content, String regex, String replacement) {
        return Builder.regexReplaceAll(content, regex, replacement);
    }

    public ValueBuilder regexReplaceAll(Expression content, String regex, Expression replacement) {
        return Builder.regexReplaceAll(content, regex, replacement);
    }

    public ValueBuilder exceptionMessage() {
        return Builder.exceptionMessage();
    }

    public Endpoint endpoint(String uri) throws NoSuchEndpointException {
        ObjectHelper.notNull(uri, "uri");
        Endpoint endpoint = this.getContext().getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public <T extends Endpoint> T endpoint(String uri, Class<T> type) throws NoSuchEndpointException {
        ObjectHelper.notNull(uri, "uri");
        T endpoint = this.getContext().getEndpoint(uri, type);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public List<Endpoint> endpoints(String ... uris) throws NoSuchEndpointException {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (String uri : uris) {
            endpoints.add(this.endpoint(uri));
        }
        return endpoints;
    }

    public List<Endpoint> endpoints(Endpoint ... endpoints) {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        answer.addAll(Arrays.asList(endpoints));
        return answer;
    }

    public DefaultErrorHandlerBuilder defaultErrorHandler() {
        return new DefaultErrorHandlerBuilder();
    }

    public NoErrorHandlerBuilder noErrorHandler() {
        return new NoErrorHandlerBuilder();
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler() {
        return new LoggingErrorHandlerBuilder();
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler(String log) {
        return this.loggingErrorHandler(LoggerFactory.getLogger((String)log));
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler(Logger log) {
        return new LoggingErrorHandlerBuilder(log);
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler(Logger log, LoggingLevel level) {
        return new LoggingErrorHandlerBuilder(log, level);
    }

    public DeadLetterChannelBuilder deadLetterChannel(String deadLetterUri) {
        return this.deadLetterChannel(this.endpoint(deadLetterUri));
    }

    public DeadLetterChannelBuilder deadLetterChannel(Endpoint deadLetterEndpoint) {
        return new DeadLetterChannelBuilder(deadLetterEndpoint);
    }

    public ModelCamelContext getContext() {
        return this.context;
    }

    public void setContext(CamelContext context) {
        ObjectHelper.notNull(context, "CamelContext", this);
        this.context = context.adapt(ModelCamelContext.class);
    }

    public void setContext(ModelCamelContext context) {
        ObjectHelper.notNull(context, "CamelContext", this);
        this.context = context;
    }

    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        return new DefaultErrorHandlerBuilder();
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }
}

