/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.springboot.DirectComponentConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DirectComponentConfiguration.class})
public class DirectComponentAutoConfiguration {
    @Bean(name={"direct-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={DirectComponent.class})
    public DirectComponent configureDirectComponent(CamelContext camelContext, DirectComponentConfiguration configuration) throws Exception {
        DirectComponent component = new DirectComponent();
        component.setCamelContext(camelContext);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), component, parameters);
        return component;
    }
}

