/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.springboot.PropertiesComponentConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={PropertiesComponentConfiguration.class})
public class PropertiesComponentAutoConfiguration {
    @Bean(name={"properties-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={PropertiesComponent.class})
    public PropertiesComponent configurePropertiesComponent(CamelContext camelContext, PropertiesComponentConfiguration configuration) throws Exception {
        PropertiesComponent component = new PropertiesComponent();
        component.setCamelContext(camelContext);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), component, parameters);
        return component;
    }
}

