/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.ZipDataFormat;
import org.apache.camel.impl.springboot.ZipDataFormatConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ZipDataFormatConfiguration.class})
public class ZipDataFormatAutoConfiguration {
    @Bean(name={"zip-dataformat"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={ZipDataFormat.class})
    public ZipDataFormat configureZipDataFormat(CamelContext camelContext, ZipDataFormatConfiguration configuration) throws Exception {
        ZipDataFormat dataformat = new ZipDataFormat();
        if (dataformat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)dataformat)).setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), dataformat, parameters);
        return dataformat;
    }
}

