/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.language.simple.springboot.SimpleLanguageConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SimpleLanguageConfiguration.class})
public class SimpleLanguageAutoConfiguration {
    @Bean(name={"simple-language"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={SimpleLanguage.class})
    public SimpleLanguage configureSimpleLanguage(CamelContext camelContext, SimpleLanguageConfiguration configuration) throws Exception {
        SimpleLanguage language = new SimpleLanguage();
        if (language instanceof CamelContextAware) {
            language.setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), language, parameters);
        return language;
    }
}

