/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer.springboot;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.language.tokenizer.TokenizeLanguage;
import org.apache.camel.language.tokenizer.springboot.TokenizeLanguageConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TokenizeLanguageConfiguration.class})
public class TokenizeLanguageAutoConfiguration {
    @Bean(name={"tokenize-language"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={TokenizeLanguage.class})
    public TokenizeLanguage configureTokenizeLanguage(CamelContext camelContext, TokenizeLanguageConfiguration configuration) throws Exception {
        TokenizeLanguage language = new TokenizeLanguage();
        if (language instanceof CamelContextAware) {
            ((CamelContextAware)((Object)language)).setCamelContext(camelContext);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(configuration, parameters, null, false);
        IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), language, parameters);
        return language;
    }
}

