/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.OnFallbackDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,routing,circuitbreaker")
@XmlRootElement(name="hystrix")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HystrixDefinition
extends ProcessorDefinition<HystrixDefinition> {
    @XmlElement
    private HystrixConfigurationDefinition hystrixConfiguration;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();
    @XmlTransient
    private OnFallbackDefinition onFallback;
    @XmlAttribute
    private String hystrixConfigurationRef;

    public String toString() {
        return "Hystrix[" + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return "hystrix";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new IllegalStateException("Cannot find camel-hystrix on the classpath.");
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorDefinition<?> output : outputs) {
                this.configureChild(output);
            }
        }
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        if (output instanceof OnFallbackDefinition) {
            this.onFallback = (OnFallbackDefinition)output;
        } else if (this.onFallback != null) {
            this.onFallback.addOutput(output);
        } else {
            super.addOutput(output);
        }
    }

    @Override
    public ProcessorDefinition<?> end() {
        if (this.onFallback != null) {
            this.onFallback.end();
        }
        return super.end();
    }

    @Override
    protected void preCreateProcessor() {
        Iterator<ProcessorDefinition<?>> it = this.outputs.iterator();
        while (it.hasNext()) {
            ProcessorDefinition<?> out = it.next();
            if (!(out instanceof OnFallbackDefinition)) continue;
            this.onFallback = (OnFallbackDefinition)out;
            it.remove();
        }
    }

    public HystrixConfigurationDefinition getHystrixConfiguration() {
        return this.hystrixConfiguration;
    }

    public void setHystrixConfiguration(HystrixConfigurationDefinition hystrixConfiguration) {
        this.hystrixConfiguration = hystrixConfiguration;
    }

    public String getHystrixConfigurationRef() {
        return this.hystrixConfigurationRef;
    }

    public void setHystrixConfigurationRef(String hystrixConfigurationRef) {
        this.hystrixConfigurationRef = hystrixConfigurationRef;
    }

    public OnFallbackDefinition getOnFallback() {
        return this.onFallback;
    }

    public void setOnFallback(OnFallbackDefinition onFallback) {
        this.onFallback = onFallback;
    }

    public HystrixDefinition groupKey(String groupKey) {
        this.hystrixConfiguration().groupKey(groupKey);
        return this;
    }

    public HystrixDefinition threadPoolKey(String threadPoolKey) {
        this.hystrixConfiguration().threadPoolKey(threadPoolKey);
        return this;
    }

    public HystrixConfigurationDefinition hystrixConfiguration() {
        this.hystrixConfiguration = new HystrixConfigurationDefinition(this);
        return this.hystrixConfiguration;
    }

    public HystrixDefinition hystrixConfiguration(HystrixConfigurationDefinition configuration) {
        this.hystrixConfiguration = configuration;
        return this;
    }

    public HystrixDefinition hystrixConfiguration(String ref) {
        this.hystrixConfigurationRef = ref;
        return this;
    }

    public HystrixDefinition onFallback() {
        this.onFallback = new OnFallbackDefinition();
        this.onFallback.setParent(this);
        return this;
    }

    public HystrixDefinition onFallbackViaNetwork() {
        this.onFallback = new OnFallbackDefinition();
        this.onFallback.setFallbackViaNetwork(true);
        this.onFallback.setParent(this);
        return this;
    }
}

