/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="language,xml", title="XQuery")
@XmlRootElement(name="xquery")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XQueryExpression
extends NamespaceAwareExpression {
    @XmlAttribute
    private String type;
    @XmlTransient
    private Class<?> resultType;
    @XmlAttribute
    private String headerName;

    public XQueryExpression() {
    }

    public XQueryExpression(String expression) {
        super(expression);
    }

    @Override
    public String getLanguage() {
        return "xquery";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        if (this.resultType == null && this.type != null) {
            try {
                this.resultType = camelContext.getClassResolver().resolveMandatoryClass(this.type);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createExpression(camelContext);
    }

    @Override
    protected void configureExpression(CamelContext camelContext, Expression expression) {
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
        if (ObjectHelper.isNotEmpty(this.getHeaderName())) {
            this.setProperty(expression, "headerName", this.getHeaderName());
        }
        super.configureExpression(camelContext, expression);
    }

    @Override
    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
        if (ObjectHelper.isNotEmpty(this.getHeaderName())) {
            this.setProperty(predicate, "headerName", this.getHeaderName());
        }
        super.configurePredicate(camelContext, predicate);
    }
}

