/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.AttributeValueExp;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.XmlLineNumberParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@ManagedResource(description="Managed Route")
public class ManagedRoute
extends ManagedPerformanceCounter
implements TimerListener,
ManagedRouteMBean {
    public static final String VALUE_UNKNOWN = "Unknown";
    private static final Logger LOG = LoggerFactory.getLogger(ManagedRoute.class);
    protected final Route route;
    protected final String description;
    protected final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();
    private final ConcurrentSkipListMap<InFlightKey, Long> exchangesInFlightStartTimestamps = new ConcurrentSkipListMap();
    private final ConcurrentHashMap<String, InFlightKey> exchangesInFlightKeys = new ConcurrentHashMap();
    private final String jmxDomain;

    public ManagedRoute(ModelCamelContext context, Route route) {
        this.route = route;
        this.context = context;
        this.description = route.getDescription();
        this.jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
        this.exchangesInFlightKeys.clear();
        this.exchangesInFlightStartTimestamps.clear();
    }

    public Route getRoute() {
        return this.route;
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public String getRouteId() {
        String id = this.route.getId();
        if (id == null) {
            id = VALUE_UNKNOWN;
        }
        return id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getEndpointUri() {
        if (this.route.getEndpoint() != null) {
            return this.route.getEndpoint().getEndpointUri();
        }
        return VALUE_UNKNOWN;
    }

    @Override
    public String getState() {
        ServiceStatus status = this.context.getRouteStatus(this.route.getId());
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @Override
    public String getUptime() {
        return this.route.getUptime();
    }

    @Override
    public long getUptimeMillis() {
        return this.route.getUptimeMillis();
    }

    @Override
    public Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    @Override
    public Boolean getTracing() {
        return this.route.getRouteContext().isTracing();
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.route.getRouteContext().setTracing(tracing);
    }

    @Override
    public Boolean getMessageHistory() {
        return this.route.getRouteContext().isMessageHistory();
    }

    @Override
    public String getRoutePolicyList() {
        List<RoutePolicy> policyList = this.route.getRouteContext().getRoutePolicyList();
        if (policyList == null || policyList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < policyList.size(); ++i) {
            RoutePolicy policy = policyList.get(i);
            sb.append(policy.getClass().getSimpleName());
            sb.append("(").append(ObjectHelper.getIdentityHashCode(policy)).append(")");
            if (i >= policyList.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    @Override
    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    @Override
    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    @Override
    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.startRoute(this.getRouteId());
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId());
    }

    @Override
    public void stop(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean stop(Long timeout, Boolean abortAfterTimeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.stopRoute(this.getRouteId(), timeout, TimeUnit.SECONDS, abortAfterTimeout);
    }

    @Override
    public void shutdown() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.stopRoute(routeId);
        this.context.removeRoute(routeId);
    }

    @Override
    public void shutdown(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        String routeId = this.getRouteId();
        this.context.stopRoute(routeId, timeout, TimeUnit.SECONDS);
        this.context.removeRoute(routeId);
    }

    @Override
    public boolean remove() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        return this.context.removeRoute(this.getRouteId());
    }

    @Override
    public String dumpRouteAsXml() throws Exception {
        return this.dumpRouteAsXml(false);
    }

    @Override
    public String dumpRouteAsXml(boolean resolvePlaceholders) throws Exception {
        String id = this.route.getId();
        RouteDefinition def = this.context.getRouteDefinition(id);
        if (def != null) {
            String xml = ModelHelper.dumpModelAsXml(this.context, def);
            if (resolvePlaceholders) {
                final AtomicBoolean changed = new AtomicBoolean();
                ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                Document dom = XmlLineNumberParser.parseXml(is, new XmlLineNumberParser.XmlTextTransformer(){

                    @Override
                    public String transform(String text) {
                        try {
                            String after = ManagedRoute.this.getContext().resolvePropertyPlaceholders(text);
                            if (!changed.get()) {
                                changed.set(!text.equals(after));
                            }
                            return after;
                        }
                        catch (Exception e) {
                            return text;
                        }
                    }
                });
                if (changed.get()) {
                    xml = this.context.getTypeConverter().mandatoryConvertTo(String.class, dom);
                    RouteDefinition copy = ModelHelper.createModelFromXml((CamelContext)this.context, xml, RouteDefinition.class);
                    xml = ModelHelper.dumpModelAsXml(this.context, copy);
                }
            }
            return xml;
        }
        return null;
    }

    @Override
    public void updateRouteFromXml(String xml) throws Exception {
        RouteDefinition def = ModelHelper.createModelFromXml((CamelContext)this.context, xml, RouteDefinition.class);
        if (def == null) {
            return;
        }
        if (ObjectHelper.isEmpty(def.getId())) {
            def.setId(this.getRouteId());
        } else if (!def.getId().equals(this.getRouteId())) {
            throw new IllegalArgumentException("Cannot update route from XML as routeIds does not match. routeId: " + this.getRouteId() + ", routeId from XML: " + def.getId());
        }
        LOG.debug("Updating route: {} from xml: {}", (Object)def.getId(), (Object)xml);
        try {
            this.context.addRouteDefinition(def);
        }
        catch (Exception e) {
            String msg = "Error updating route: " + def.getId() + " from xml: " + xml + " due: " + e.getMessage();
            LOG.warn(msg, (Throwable)e);
            throw e;
        }
    }

    @Override
    public String dumpRouteStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        long routeSelfTime;
        StringBuilder sb = new StringBuilder();
        Long processorAccumulatedTime = 0L;
        if (includeProcessors) {
            sb.append("  <processorStats>\n");
            MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
            if (server != null) {
                String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
                ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                    if (!this.getRouteId().equals(processor.getRouteId())) continue;
                    mps.add(processor);
                }
                mps.sort(new OrderProcessorMBeans());
                HashMap<String, Long> accumulatedTimes = new HashMap<String, Long>();
                Collections.reverse(mps);
                for (ManagedProcessorMBean processor : mps) {
                    processorAccumulatedTime = processorAccumulatedTime + processor.getTotalProcessingTime();
                    accumulatedTimes.put(processor.getProcessorId(), processorAccumulatedTime);
                }
                Collections.reverse(mps);
                for (ManagedProcessorMBean processor : mps) {
                    sb.append("    <processorStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\"", processor.getProcessorId(), processor.getIndex(), processor.getState()));
                    Long accTime = (Long)accumulatedTimes.get(processor.getProcessorId());
                    if (accTime != null) {
                        sb.append(" accumulatedProcessingTime=\"").append(accTime).append("\"");
                    }
                    sb.append(" ").append(processor.dumpStatsAsXml(fullStats).substring(7)).append("\n");
                }
            }
            sb.append("  </processorStats>\n");
        }
        if ((routeSelfTime = this.getTotalProcessingTime() - processorAccumulatedTime) < 0L) {
            routeSelfTime = 0L;
        }
        StringBuilder answer = new StringBuilder();
        answer.append("<routeStat").append(String.format(" id=\"%s\"", this.route.getId())).append(String.format(" state=\"%s\"", this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        answer.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        answer.append(" selfProcessingTime=\"").append(routeSelfTime).append("\"");
        InFlightKey oldestInflightEntry = this.getOldestInflightEntry();
        if (oldestInflightEntry == null) {
            answer.append(" oldestInflightExchangeId=\"\"");
            answer.append(" oldestInflightDuration=\"\"");
        } else {
            answer.append(" oldestInflightExchangeId=\"").append(oldestInflightEntry.exchangeId).append("\"");
            answer.append(" oldestInflightDuration=\"").append(System.currentTimeMillis() - oldestInflightEntry.timeStamp).append("\"");
        }
        answer.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        if (includeProcessors) {
            answer.append((CharSequence)sb);
        }
        answer.append("</routeStat>");
        return answer.toString();
    }

    @Override
    public void reset(boolean includeProcessors) throws Exception {
        MBeanServer server;
        this.reset();
        if (includeProcessors && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
            QueryExp queryExp = Query.match(new AttributeValueExp("RouteId"), new StringValueExp(this.getRouteId()));
            Set<ObjectName> names = server.queryNames(query, queryExp);
            for (ObjectName name : names) {
                server.invoke(name, "reset", null, null);
            }
        }
    }

    @Override
    public String createRouteStaticEndpointJson() {
        return this.getContext().createRouteStaticEndpointJson(this.getRouteId());
    }

    @Override
    public String createRouteStaticEndpointJson(boolean includeDynamic) {
        return this.getContext().createRouteStaticEndpointJson(this.getRouteId(), includeDynamic);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.route.equals(((ManagedRoute)o).route);
    }

    public int hashCode() {
        return this.route.hashCode();
    }

    private InFlightKey getOldestInflightEntry() {
        Map.Entry<InFlightKey, Long> entry = this.exchangesInFlightStartTimestamps.firstEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Long getOldestInflightDuration() {
        InFlightKey oldest = this.getOldestInflightEntry();
        if (oldest == null) {
            return null;
        }
        return System.currentTimeMillis() - oldest.timeStamp;
    }

    @Override
    public String getOldestInflightExchangeId() {
        InFlightKey oldest = this.getOldestInflightEntry();
        if (oldest == null) {
            return null;
        }
        return oldest.exchangeId;
    }

    @Override
    public synchronized void processExchange(Exchange exchange) {
        InFlightKey key = new InFlightKey(System.currentTimeMillis(), exchange.getExchangeId());
        InFlightKey oldKey = this.exchangesInFlightKeys.putIfAbsent(exchange.getExchangeId(), key);
        if (oldKey == null) {
            this.exchangesInFlightStartTimestamps.put(key, key.timeStamp);
        }
        super.processExchange(exchange);
    }

    @Override
    public synchronized void completedExchange(Exchange exchange, long time) {
        InFlightKey key = this.exchangesInFlightKeys.remove(exchange.getExchangeId());
        if (key != null) {
            this.exchangesInFlightStartTimestamps.remove(key);
        }
        super.completedExchange(exchange, time);
    }

    @Override
    public synchronized void failedExchange(Exchange exchange) {
        InFlightKey key = this.exchangesInFlightKeys.remove(exchange.getExchangeId());
        if (key != null) {
            this.exchangesInFlightStartTimestamps.remove(key);
        }
        super.failedExchange(exchange);
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }

    private static class InFlightKey
    implements Comparable<InFlightKey> {
        private final Long timeStamp;
        private final String exchangeId;

        InFlightKey(Long timeStamp, String exchangeId) {
            this.timeStamp = timeStamp;
            this.exchangeId = exchangeId;
        }

        @Override
        public int compareTo(InFlightKey o) {
            int compare = Long.compare(this.timeStamp, o.timeStamp);
            if (compare == 0) {
                return this.exchangeId.compareTo(o.exchangeId);
            }
            return compare;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InFlightKey that = (InFlightKey)o;
            if (!this.exchangeId.equals(that.exchangeId)) {
                return false;
            }
            return this.timeStamp.equals(that.timeStamp);
        }

        public int hashCode() {
            int result = this.timeStamp.hashCode();
            result = 31 * result + this.exchangeId.hashCode();
            return result;
        }

        public String toString() {
            return this.exchangeId;
        }
    }
}

