/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentResolver
implements ComponentResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/component/";
    private static final transient Log LOG = LogFactory.getLog(DefaultComponentResolver.class);
    private FactoryFinder factoryFinder;

    @Override
    public Component resolveComponent(String name, CamelContext context) {
        Class<?> type;
        Object bean = null;
        try {
            bean = context.getRegistry().lookup(name);
            if (bean != null && this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Found component: " + name + " in registry: " + bean));
            }
        }
        catch (Exception e) {
            this.getLog().debug((Object)("Ignored error looking up bean: " + name), (Throwable)e);
        }
        if (bean != null && bean instanceof Component) {
            return (Component)bean;
        }
        try {
            type = this.findComponent(name, context);
            if (type == null) {
                return null;
            }
        }
        catch (NoFactoryAvailableException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Component registered for scheme: " + name, e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Found component: " + name + " via type: " + type.getName() + " via: " + this.factoryFinder.getResourcePath() + name));
        }
        if (Component.class.isAssignableFrom(type)) {
            return (Component)context.getInjector().newInstance(type);
        }
        throw new IllegalArgumentException("Type is not a Component implementation. Found: " + type.getName());
    }

    private Class<?> findComponent(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = context.getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }

    protected Log getLog() {
        return LOG;
    }
}

