/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SortProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="sort")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SortDefinition
extends OutputDefinition<SortDefinition> {
    @XmlTransient
    private Comparator<Object> comparator;
    @XmlAttribute(required=false)
    private String comparatorRef;
    @XmlElement(name="expression", required=false)
    private ExpressionSubElementDefinition expression;

    public SortDefinition() {
    }

    public SortDefinition(Expression expression) {
        this.setExpression(expression);
    }

    public SortDefinition(Expression expression, Comparator<Object> comparator) {
        this(expression);
        this.comparator = comparator;
    }

    public String toString() {
        return "sort[" + this.getExpression() + " by: " + (this.comparatorRef != null ? "ref:" + this.comparatorRef : this.comparator) + "]";
    }

    @Override
    public String getShortName() {
        return "sort";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression exp;
        if (ObjectHelper.isNotEmpty(this.comparatorRef)) {
            this.comparator = routeContext.getCamelContext().getRegistry().lookup(this.comparatorRef, Comparator.class);
        }
        if (this.comparator == null) {
            this.comparator = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ObjectHelper.compare(o1, o2);
                }
            };
        }
        if (this.getExpression() == null) {
            this.setExpression(ExpressionBuilder.bodyExpression());
        }
        if ((exp = this.expression.getExpression()) == null) {
            exp = this.expression.getExpressionType();
        }
        return new SortProcessor(exp, this.getComparator());
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    public String getComparatorRef() {
        return this.comparatorRef;
    }

    public void setComparatorRef(String comparatorRef) {
        this.comparatorRef = comparatorRef;
    }

    public ExpressionSubElementDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = new ExpressionSubElementDefinition(expression);
    }

    public void setExpression(ExpressionSubElementDefinition expression) {
        this.expression = expression;
    }

    public SortDefinition comparator(Comparator<Object> comparator) {
        this.setComparator(comparator);
        return this;
    }

    public SortDefinition comparatorRef(String ref) {
        this.setComparatorRef(ref);
        return this;
    }
}

