/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.ha;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.apache.camel.CamelContext;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.ha.CamelClusterView;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.concurrent.LockHelper;

public abstract class AbstractCamelClusterService<T extends CamelClusterView>
extends ServiceSupport
implements CamelClusterService {
    private final Map<String, T> views;
    private final StampedLock lock;
    private String id;
    private CamelContext camelContext;

    protected AbstractCamelClusterService() {
        this(null, null);
    }

    protected AbstractCamelClusterService(String id) {
        this(id, null);
    }

    protected AbstractCamelClusterService(String id, CamelContext camelContext) {
        this.id = id;
        this.camelContext = camelContext;
        this.views = new HashMap<String, T>();
        this.lock = new StampedLock();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        LockHelper.doWithWriteLock(this.lock, () -> {
            for (CamelClusterView view : this.views.values()) {
                view.setCamelContext(camelContext);
            }
        });
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        LockHelper.doWithReadLockT(this.lock, () -> {
            for (CamelClusterView view : this.views.values()) {
                view.start();
            }
        });
    }

    @Override
    protected void doStop() throws Exception {
        LockHelper.doWithReadLockT(this.lock, () -> {
            for (CamelClusterView view : this.views.values()) {
                view.stop();
            }
        });
    }

    @Override
    public CamelClusterView getView(String namespace) throws Exception {
        return LockHelper.callWithWriteLock(this.lock, () -> {
            CamelClusterView view = (CamelClusterView)this.views.get(namespace);
            if (view == null) {
                view = this.createView(namespace);
                view.setCamelContext(this.camelContext);
                this.views.put(namespace, view);
                if (this.isRunAllowed()) {
                    view.start();
                }
            }
            return view;
        });
    }

    protected abstract T createView(String var1) throws Exception;
}

