/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.ha;

import java.time.Duration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupListener;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.ha.CamelClusterEventListener;
import org.apache.camel.ha.CamelClusterMember;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.ha.CamelClusterView;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ReferenceCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Clustered Route policy using")
public class ClusteredRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusteredRoutePolicy.class);
    private final AtomicBoolean leader;
    private final Set<Route> startedRoutes;
    private final Set<Route> stoppedRoutes;
    private final ReferenceCount refCount;
    private final CamelClusterView clusterView;
    private final CamelClusterEventListener.Leadership leadershipEventListener;
    private final CamelContextStartupListener listener;
    private final AtomicBoolean contextStarted;
    private Duration initialDelay;
    private ScheduledExecutorService executorService;
    private CamelContext camelContext;

    public ClusteredRoutePolicy(CamelClusterView clusterView) {
        this.clusterView = clusterView;
        this.leadershipEventListener = new CamelClusterLeadershipListener();
        this.stoppedRoutes = new HashSet<Route>();
        this.startedRoutes = new HashSet<Route>();
        this.leader = new AtomicBoolean(false);
        this.contextStarted = new AtomicBoolean(false);
        this.initialDelay = Duration.ofMillis(0L);
        try {
            this.listener = new CamelContextStartupListener();
            this.listener.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.refCount = ReferenceCount.onRelease(() -> {
            if (this.camelContext != null) {
                this.camelContext.getManagementStrategy().removeEventNotifier(this.listener);
                if (this.executorService != null) {
                    this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
                }
            }
            clusterView.removeEventListener(this.leadershipEventListener);
            this.setLeader(false);
        });
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        if (this.camelContext == camelContext) {
            return;
        }
        if (this.camelContext != null && this.camelContext != camelContext) {
            throw new IllegalStateException("CamelContext should not be changed: current=" + this.camelContext + ", new=" + camelContext);
        }
        try {
            this.camelContext = camelContext;
            this.camelContext.addStartupListener(this.listener);
            this.camelContext.getManagementStrategy().addEventNotifier(this.listener);
            this.executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "ClusteredRoutePolicy");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Override
    public void onInit(Route route) {
        super.onInit(route);
        LOGGER.info("Route managed by {}. Setting route {} AutoStartup flag to false.", this.getClass(), (Object)route.getId());
        route.getRouteContext().getRoute().setAutoStartup("false");
        this.refCount.retain();
        this.stoppedRoutes.add(route);
        this.startManagedRoutes();
    }

    @Override
    public void doShutdown() throws Exception {
        this.refCount.release();
    }

    @ManagedAttribute(description="Is this route the master or a slave")
    public boolean isLeader() {
        return this.leader.get();
    }

    private synchronized void setLeader(boolean isLeader) {
        if (isLeader && this.leader.compareAndSet(false, isLeader)) {
            LOGGER.debug("Leadership taken");
            this.startManagedRoutes();
        } else if (!isLeader && this.leader.getAndSet(isLeader)) {
            LOGGER.debug("Leadership lost");
            this.stopManagedRoutes();
        }
    }

    private void startManagedRoutes() {
        if (this.isLeader()) {
            this.doStartManagedRoutes();
        } else {
            this.doStopManagedRoutes();
        }
    }

    private void doStartManagedRoutes() {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            for (Route route : this.stoppedRoutes) {
                ServiceStatus status = route.getRouteContext().getRoute().getStatus(this.getCamelContext());
                if (!status.isStartable()) continue;
                LOGGER.debug("Starting route '{}'", (Object)route.getId());
                this.camelContext.startRoute(route.getId());
                this.startedRoutes.add(route);
            }
            this.stoppedRoutes.removeAll(this.startedRoutes);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void stopManagedRoutes() {
        if (this.isLeader()) {
            this.doStartManagedRoutes();
        } else {
            this.doStopManagedRoutes();
        }
    }

    private void doStopManagedRoutes() {
        if (!this.isRunAllowed()) {
            return;
        }
        try {
            for (Route route : this.startedRoutes) {
                ServiceStatus status = route.getRouteContext().getRoute().getStatus(this.getCamelContext());
                if (!status.isStoppable()) continue;
                LOGGER.debug("Stopping route '{}'", (Object)route.getId());
                this.stopRoute(route);
                this.stoppedRoutes.add(route);
            }
            this.startedRoutes.removeAll(this.stoppedRoutes);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void onCamelContextStarted() {
        LOGGER.debug("Apply cluster policy (stopped-routes='{}', started-routes='{}')", (Object)this.stoppedRoutes.stream().map(Route::getId).collect(Collectors.joining(",")), (Object)this.startedRoutes.stream().map(Route::getId).collect(Collectors.joining(",")));
        this.clusterView.addEventListener(this.leadershipEventListener);
        this.setLeader(this.clusterView.getLocalMember().isMaster());
    }

    public static ClusteredRoutePolicy forNamespace(CamelContext camelContext, String namespace) throws Exception {
        CamelClusterService cluster = camelContext.hasService(CamelClusterService.class);
        if (cluster == null) {
            throw new IllegalStateException("CamelCluster service not found");
        }
        return ClusteredRoutePolicy.forNamespace(cluster, namespace);
    }

    public static ClusteredRoutePolicy forNamespace(CamelClusterService cluster, String namespace) throws Exception {
        return ClusteredRoutePolicy.forView(cluster.getView(namespace));
    }

    public static ClusteredRoutePolicy forView(CamelClusterView view) throws Exception {
        ClusteredRoutePolicy policy = new ClusteredRoutePolicy(view);
        policy.setCamelContext(view.getCamelContext());
        return policy;
    }

    private class CamelContextStartupListener
    extends EventNotifierSupport
    implements StartupListener {
        private CamelContextStartupListener() {
        }

        @Override
        public void notify(EventObject event) throws Exception {
            this.onCamelContextStarted();
        }

        @Override
        public boolean isEnabled(EventObject event) {
            return event instanceof CamelContextStartedEvent;
        }

        @Override
        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            if (alreadyStarted) {
                this.onCamelContextStarted();
            }
        }

        private void onCamelContextStarted() {
            if (ClusteredRoutePolicy.this.contextStarted.compareAndSet(false, true)) {
                if (ClusteredRoutePolicy.this.initialDelay.toMillis() > 0L) {
                    LOGGER.debug("Policy will be effective in {}", (Object)ClusteredRoutePolicy.this.initialDelay);
                    ClusteredRoutePolicy.this.executorService.schedule(() -> ClusteredRoutePolicy.this.onCamelContextStarted(), ClusteredRoutePolicy.this.initialDelay.toMillis(), TimeUnit.MILLISECONDS);
                } else {
                    ClusteredRoutePolicy.this.onCamelContextStarted();
                }
            }
        }
    }

    private class CamelClusterLeadershipListener
    implements CamelClusterEventListener.Leadership {
        private CamelClusterLeadershipListener() {
        }

        @Override
        public void leadershipChanged(CamelClusterView view, CamelClusterMember leader) {
            ClusteredRoutePolicy.this.setLeader(ClusteredRoutePolicy.this.clusterView.getLocalMember().isMaster());
        }
    }
}

