/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Producer;
import org.apache.camel.impl.EmptyProducerCache;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enricher
extends ServiceSupport
implements AsyncProcessor,
IdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(Enricher.class);
    private CamelContext camelContext;
    private String id;
    private ProducerCache producerCache;
    private final Expression expression;
    private AggregationStrategy aggregationStrategy;
    private boolean aggregateOnException;
    private boolean shareUnitOfWork;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;

    public Enricher(Expression expression) {
        this.expression = expression;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Producer producer;
        Endpoint endpoint;
        Object recipient = null;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            endpoint = this.resolveEndpoint(exchange, recipient);
            producer = this.producerCache.acquireProducer(endpoint);
        }
        catch (Throwable e) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", e);
                }
            } else {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        final Exchange resourceExchange = this.createResourceExchange(exchange, ExchangePattern.InOut);
        final Endpoint destination = producer.getEndpoint();
        StopWatch sw = null;
        boolean sending = EventHelper.notifyExchangeSending(exchange.getContext(), resourceExchange, destination);
        if (sending) {
            sw = new StopWatch();
        }
        final StopWatch watch = sw;
        AsyncProcessor ap = AsyncProcessorConverterHelper.convert(producer);
        boolean sync = ap.process(resourceExchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                if (watch != null) {
                    long timeTaken = watch.taken();
                    EventHelper.notifyExchangeSent(resourceExchange.getContext(), resourceExchange, destination, timeTaken);
                }
                if (!Enricher.this.isAggregateOnException() && resourceExchange.isFailed()) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
                } else {
                    Enricher.prepareResult(exchange);
                    try {
                        ExchangeHelper.prepareAggregation(exchange, resourceExchange);
                        Exchange aggregatedExchange = Enricher.this.aggregationStrategy.aggregate(exchange, resourceExchange);
                        if (aggregatedExchange != null) {
                            ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                        }
                    }
                    catch (Throwable e) {
                        exchange.setException(new CamelExchangeException("Error occurred during aggregation", exchange, e));
                        callback.done(false);
                        return;
                    }
                }
                exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
                try {
                    Enricher.this.producerCache.releaseProducer(endpoint, producer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                callback.done(false);
            }
        });
        if (!sync) {
            LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
            return false;
        }
        LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        if (watch != null) {
            long timeTaken = watch.taken();
            EventHelper.notifyExchangeSent(resourceExchange.getContext(), resourceExchange, destination, timeTaken);
        }
        if (!this.isAggregateOnException() && resourceExchange.isFailed()) {
            ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
        } else {
            Enricher.prepareResult(exchange);
            try {
                ExchangeHelper.prepareAggregation(exchange, resourceExchange);
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                }
            }
            catch (Throwable e) {
                exchange.setException(new CamelExchangeException("Error occurred during aggregation", exchange, e));
                callback.done(true);
                return true;
            }
        }
        exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
        try {
            this.producerCache.releaseProducer(endpoint, producer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        callback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected Exchange createResourceExchange(Exchange source, ExchangePattern pattern) {
        Exchange target = ExchangeHelper.createCorrelatedCopy(source, false);
        target.setPattern(pattern);
        if (this.isShareUnitOfWork()) {
            target.setProperty("CamelParentUnitOfWork", source.getUnitOfWork());
            target.setUnitOfWork(source.getUnitOfWork());
        }
        return target;
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "Enrich[" + this.expression + "]";
    }

    @Override
    protected void doStart() throws Exception {
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = Enricher.defaultAggregationStrategy();
        }
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                LOG.debug("Enricher {} is not using ProducerCache", (Object)this);
            } else if (this.cacheSize == 0) {
                this.producerCache = new ProducerCache(this, this.camelContext);
                LOG.debug("Enricher {} using ProducerCache with default cache size", (Object)this);
            } else {
                this.producerCache = new ProducerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("Enricher {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startServices(this.producerCache, this.aggregationStrategy);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.aggregationStrategy, this.producerCache);
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            }
            return oldExchange;
        }
    }
}

