/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanProcessor
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBeanProcessor.class);
    private final BeanHolder beanHolder;
    private transient Processor processor;
    private transient boolean lookupProcessorDone;
    private final Object lock = new Object();
    private boolean multiParameterArray;
    private String method;
    private boolean shorthandMethod;

    public AbstractBeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    public AbstractBeanProcessor(Object pojo, CamelContext camelContext, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(camelContext, pojo.getClass(), parameterMappingStrategy));
    }

    public AbstractBeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, camelContext, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public AbstractBeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        return "BeanProcessor[" + this.beanHolder + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        MethodInvocation invocation;
        BeanInfo beanInfo;
        Object bean;
        String explicitMethodName = exchange.getIn().getHeader("CamelBeanMethodName", this.method, String.class);
        try {
            bean = this.beanHolder.getBean();
            beanInfo = this.beanHolder.getBeanInfo(bean);
            if (beanInfo == null) {
                beanInfo = this.beanHolder.getBeanInfo();
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        if (this.allowProcessor(explicitMethodName, beanInfo)) {
            this.processor = this.getProcessor();
            if (this.processor == null && !this.lookupProcessorDone) {
                Object e = this.lock;
                synchronized (e) {
                    this.lookupProcessorDone = true;
                    this.processor = exchange.getContext().getTypeConverter().tryConvertTo(Processor.class, exchange, bean);
                }
            }
            if (this.processor != null) {
                LOG.trace("Using a custom adapter as bean invocation: {}", (Object)this.processor);
                try {
                    this.processor.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                callback.done(true);
                return true;
            }
        }
        Message in = exchange.getIn();
        BeanInvocation beanInvoke = null;
        if (in.getBody() instanceof BeanInvocation) {
            beanInvoke = (BeanInvocation)in.getBody();
        }
        if (beanInvoke != null) {
            LOG.trace("Exchange IN body is a BeanInvocation instance: {}", (Object)beanInvoke);
            Class<?> clazz = beanInvoke.getMethod().getDeclaringClass();
            boolean sameBean = clazz.isInstance(bean);
            if (LOG.isDebugEnabled()) {
                LOG.debug("BeanHolder bean: {} and beanInvocation bean: {} is same instance: {}", new Object[]{bean.getClass(), clazz, sameBean});
            }
            if (sameBean) {
                try {
                    beanInvoke.invoke(bean, exchange);
                    if (exchange.hasOut()) {
                        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                    }
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                callback.done(true);
                return true;
            }
        }
        if (this.isMultiParameterArray()) {
            in.setHeader("CamelBeanMultiParameterArray", Boolean.TRUE);
        }
        if (explicitMethodName != null) {
            in.setHeader("CamelBeanMethodName", explicitMethodName);
        }
        try {
            invocation = beanInfo.createInvocation(bean, exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.isMultiParameterArray()) {
                in.removeHeader("CamelBeanMultiParameterArray");
            }
            if (explicitMethodName != null) {
                in.removeHeader("CamelBeanMethodName");
            }
        }
        if (invocation == null) {
            exchange.setException(new IllegalStateException("No method invocation could be created, no matching method could be found on: " + bean));
            callback.done(true);
            return true;
        }
        return invocation.proceed(callback);
    }

    protected Processor getProcessor() {
        return this.processor;
    }

    protected BeanHolder getBeanHolder() {
        return this.beanHolder;
    }

    public Object getBean() {
        return this.beanHolder.getBean();
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMultiParameterArray() {
        return this.multiParameterArray;
    }

    public void setMultiParameterArray(boolean mpArray) {
        this.multiParameterArray = mpArray;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isShorthandMethod() {
        return this.shorthandMethod;
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.shorthandMethod = shorthandMethod;
    }

    protected void doStart() throws Exception {
        if (this.beanHolder.supportProcessor() && this.allowProcessor(this.method, this.beanHolder.getBeanInfo())) {
            this.processor = this.beanHolder.getProcessor();
            ServiceHelper.startService(this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.startService(this.beanHolder.getBean());
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.processor != null) {
            ServiceHelper.stopService(this.processor);
        } else if (this.beanHolder instanceof ConstantBeanHolder) {
            try {
                ServiceHelper.stopService(this.beanHolder.getBean());
            }
            catch (NoSuchBeanException noSuchBeanException) {
                // empty catch block
            }
        }
    }

    private boolean allowProcessor(String explicitMethodName, BeanInfo info) {
        if (explicitMethodName != null) {
            return false;
        }
        return !info.hasAnyMethodHandlerAnnotation();
    }
}

