/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Delayer;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="delay")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DelayDefinition
extends ExpressionNode {
    public DelayDefinition() {
    }

    public DelayDefinition(Expression delay) {
        super(delay);
    }

    public String getLabel() {
        return "delay";
    }

    public String getShortName() {
        return "delay";
    }

    public String toString() {
        return "Delay[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public DelayDefinition delayTime(Long delay) {
        this.setExpression(new ExpressionDefinition(ExpressionBuilder.constantExpression(delay)));
        return this;
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        Expression delay = this.createAbsoluteTimeDelayExpression(routeContext);
        return new Delayer(childProcessor, delay);
    }

    private Expression createAbsoluteTimeDelayExpression(RouteContext routeContext) {
        ExpressionDefinition expr = this.getExpression();
        if (expr != null && (ObjectHelper.isNotEmpty(expr.getExpression()) || expr.getExpressionValue() != null)) {
            return expr.createExpression(routeContext);
        }
        return null;
    }
}

