/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="throttle")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrottleDefinition
extends OutputDefinition<ProcessorDefinition> {
    @XmlAttribute
    private Long maximumRequestsPerPeriod;
    @XmlAttribute
    private long timePeriodMillis = 1000L;

    public ThrottleDefinition() {
    }

    public ThrottleDefinition(long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public String toString() {
        return "Throttle[" + this.getMaximumRequestsPerPeriod() + " request per " + this.getTimePeriodMillis() + " millis -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "throttle";
    }

    @Override
    public String getLabel() {
        return "" + this.getMaximumRequestsPerPeriod() + " per " + this.getTimePeriodMillis() + " (ms)";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        return new Throttler(childProcessor, this.maximumRequestsPerPeriod, this.timePeriodMillis);
    }

    public ThrottleDefinition timePeriodMillis(long timePeriodMillis) {
        this.setTimePeriodMillis(timePeriodMillis);
        return this;
    }

    public ThrottleDefinition maximumRequestsPerPeriod(Long maximumRequestsPerPeriod) {
        this.setMaximumRequestsPerPeriod(maximumRequestsPerPeriod);
        return this;
    }

    public Long getMaximumRequestsPerPeriod() {
        return this.maximumRequestsPerPeriod;
    }

    public void setMaximumRequestsPerPeriod(Long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public long getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }
}

