/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.AtomicExchange;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor>,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(MulticastProcessor.class);
    private final CamelContext camelContext;
    private Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean parallelProcessing;
    private final boolean streaming;
    private final boolean stopOnException;
    private final ExecutorService executorService;

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors) {
        this(camelContext, processors, null);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(camelContext, processors, aggregationStrategy, false, null, false, false);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming, boolean stopOnException) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processors, "processors");
        this.camelContext = camelContext;
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        this.parallelProcessing = parallelProcessing || executorService != null;
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "multicast";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AtomicExchange result = new AtomicExchange();
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
        try {
            if (this.isParallelProcessing()) {
                ObjectHelper.notNull(this.executorService, "executorService", this);
                this.doProcessParallel(result, pairs, this.isStreaming());
            } else {
                this.doProcessSequential(result, pairs);
            }
            if (result.get() != null) {
                ExchangeHelper.copyResults(exchange, (Exchange)result.get());
            }
        }
        catch (Exception e) {
            exchange.setProperty("CamelRedeliveryExhausted", Boolean.TRUE);
            exchange.setException(e);
        }
    }

    protected void doProcessParallel(AtomicExchange result, Iterable<ProcessorExchangePair> pairs, boolean streaming) throws InterruptedException, ExecutionException {
        final AtomicBoolean running = new AtomicBoolean(true);
        CompletionService completion = streaming ? new ExecutorCompletionService(this.executorService) : new SubmitOrderedCompletionService(this.executorService);
        final AtomicInteger total = new AtomicInteger(0);
        for (ProcessorExchangePair pair : pairs) {
            final Processor processor = pair.getProcessor();
            final Processor prepared = pair.getPrepared();
            final Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.intValue(), pairs);
            completion.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    if (!running.get()) {
                        return subExchange;
                    }
                    MulticastProcessor.this.doProcess(processor, prepared, subExchange);
                    if (MulticastProcessor.this.stopOnException && subExchange.getException() != null) {
                        running.set(false);
                        throw new CamelExchangeException("Parallel processing failed for number " + total.intValue(), subExchange, subExchange.getException());
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Parallel processing complete for exchange: " + subExchange));
                    }
                    return subExchange;
                }
            });
            total.incrementAndGet();
        }
        for (int i = 0; i < total.intValue(); ++i) {
            Future future = completion.take();
            Exchange subExchange = (Exchange)future.get();
            if (this.aggregationStrategy == null) continue;
            this.doAggregate(result, subExchange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done parallel processing " + total + " exchanges"));
        }
    }

    protected void doProcessSequential(AtomicExchange result, Iterable<ProcessorExchangePair> pairs) throws Exception {
        int total = 0;
        for (ProcessorExchangePair pair : pairs) {
            Processor processor = pair.getProcessor();
            Processor prepared = pair.getPrepared();
            Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total, pairs);
            this.doProcess(processor, prepared, subExchange);
            if (this.stopOnException && subExchange.getException() != null) {
                throw new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sequential processing complete for number " + total + " exchange: " + subExchange));
            }
            if (this.aggregationStrategy != null) {
                this.doAggregate(result, subExchange);
            }
            ++total;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done sequential processing " + total + " exchanges"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Processor processor, Processor prepared, Exchange exchange) {
        TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
        StopWatch watch = null;
        if (processor instanceof Producer) {
            watch = new StopWatch();
        }
        try {
            if (traced != null) {
                traced.pushBlock();
            }
            prepared.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            if (traced != null) {
                traced.popBlock();
            }
            if (processor instanceof Producer) {
                long timeTaken = watch.stop();
                Endpoint endpoint = ((Producer)processor).getEndpoint();
                EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
            }
        }
    }

    protected synchronized void doAggregate(AtomicExchange result, Exchange exchange) {
        if (this.aggregationStrategy != null) {
            Exchange oldExchange = (Exchange)result.get();
            ExchangeHelper.prepareAggregation(oldExchange, exchange);
            result.set(this.aggregationStrategy.aggregate(oldExchange, exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs) {
        exchange.setProperty("CamelMulticastIndex", index);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        for (Processor processor : this.processors) {
            Exchange copy = exchange.copy();
            result.add(MulticastProcessor.createProcessorExchangePair(processor, copy));
        }
        return result;
    }

    protected static ProcessorExchangePair createProcessorExchangePair(Processor processor, Exchange exchange) {
        Processor prepared = processor;
        MulticastProcessor.setToEndpoint(exchange, prepared);
        if (exchange.getUnitOfWork() != null && exchange.getUnitOfWork().getRouteContext() != null) {
            RouteContext routeContext = exchange.getUnitOfWork().getRouteContext();
            ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
            try {
                prepared = builder.createErrorHandler(routeContext, prepared);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return new ProcessorExchangePair(processor, prepared, exchange);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isParallelProcessing() && this.executorService == null) {
            throw new IllegalArgumentException("ParallelProcessing is enabled but ExecutorService has not been set");
        }
        ServiceHelper.startServices(this.processors);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors);
    }

    private static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
        }
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    static final class ProcessorExchangePair {
        private final Processor processor;
        private final Processor prepared;
        private final Exchange exchange;

        private ProcessorExchangePair(Processor processor, Processor prepared, Exchange exchange) {
            this.processor = processor;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public Processor getPrepared() {
            return this.prepared;
        }

        public Exchange getExchange() {
            return this.exchange;
        }
    }
}

