/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements Processor,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(Pipeline.class);

    public Pipeline(CamelContext camelContext, Collection<Processor> processors) {
        super(camelContext, processors);
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(camelContext, processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Iterator<Processor> processors = this.getProcessors().iterator();
        Exchange nextExchange = exchange;
        boolean first = true;
        while (this.continueRouting(processors, nextExchange)) {
            if (first) {
                first = false;
            } else {
                nextExchange = this.createNextExchange(nextExchange);
            }
            Processor processor = processors.next();
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + nextExchange.getExchangeId() + " >>> " + nextExchange));
                }
                processor.process(nextExchange);
            }
            catch (Exception e) {
                nextExchange.setException(e);
            }
            boolean exceptionHandled = Pipeline.hasExceptionBeenHandledByErrorHandler(nextExchange);
            if (!nextExchange.isFailed() && !nextExchange.isRollbackOnly() && !exceptionHandled) continue;
            if (!LOG.isDebugEnabled()) break;
            StringBuilder sb = new StringBuilder();
            sb.append("Message exchange has failed so breaking out of pipeline: ").append(nextExchange);
            if (nextExchange.isRollbackOnly()) {
                sb.append(" Marked as rollback only.");
            }
            if (nextExchange.getException() != null) {
                sb.append(" Exception: ").append(nextExchange.getException());
            }
            if (nextExchange.hasOut() && nextExchange.getOut().isFault()) {
                sb.append(" Fault: ").append(nextExchange.getOut());
            }
            if (exceptionHandled) {
                sb.append(" Handled by the error handler.");
            }
            LOG.debug((Object)sb.toString());
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing complete for exchangeId: " + exchange.getExchangeId() + " >>> " + nextExchange));
        }
        ExchangeHelper.copyResults(exchange, nextExchange);
    }

    private static boolean hasExceptionBeenHandledByErrorHandler(Exchange nextExchange) {
        return Boolean.TRUE.equals(nextExchange.getProperty("CamelErrorHandlerHandled"));
    }

    protected Exchange createNextExchange(Exchange previousExchange) {
        DefaultExchange answer = new DefaultExchange(previousExchange);
        answer.setExchangeId(previousExchange.getExchangeId());
        answer.getProperties().putAll(previousExchange.getProperties());
        answer.setIn(previousExchange.hasOut() ? previousExchange.getOut().copy() : previousExchange.getIn().copy());
        return answer;
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop).booleanValue())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exchange is marked to stop routing: " + exchange));
            }
            return false;
        }
        return it.hasNext();
    }

    @Override
    public String toString() {
        return "Pipeline" + this.getProcessors();
    }

    @Override
    public String getTraceLabel() {
        return "pipeline";
    }
}

