/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecipientList
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(RecipientList.class);
    private final CamelContext camelContext;
    private ProducerCache producerCache;
    private Expression expression;
    private final String delimiter;
    private boolean parallelProcessing;
    private boolean stopOnException;
    private boolean ignoreInvalidEndpoints;
    private ExecutorService executorService;
    private AggregationStrategy aggregationStrategy = new UseLatestAggregationStrategy();

    public RecipientList(CamelContext camelContext) {
        this(camelContext, ",");
    }

    public RecipientList(CamelContext camelContext, String delimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notEmpty(delimiter, "delimiter");
        this.camelContext = camelContext;
        this.delimiter = delimiter;
    }

    public RecipientList(CamelContext camelContext, Expression expression) {
        this(camelContext, expression, ",");
    }

    public RecipientList(CamelContext camelContext, Expression expression, String delimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notEmpty(delimiter, "delimiter");
        this.camelContext = camelContext;
        this.expression = expression;
        this.delimiter = delimiter;
    }

    public String toString() {
        return "RecipientList[" + (this.expression != null ? this.expression : "") + "]";
    }

    public void process(Exchange exchange) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("RecipientList has not been started: " + this);
        }
        Object recipientList = this.expression.evaluate(exchange, Object.class);
        this.sendToRecipientList(exchange, recipientList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToRecipientList(Exchange exchange, Object recipientList) throws Exception {
        Iterator<Object> iter = ObjectHelper.createIterator(recipientList, this.delimiter);
        LinkedHashMap<Endpoint, Producer> producers = new LinkedHashMap<Endpoint, Producer>();
        try {
            ArrayList<Processor> processors = new ArrayList<Processor>();
            while (iter.hasNext()) {
                Object recipient = iter.next();
                try {
                    Endpoint endpoint = this.resolveEndpoint(exchange, recipient);
                    Producer producer = this.producerCache.acquireProducer(endpoint);
                    processors.add(producer);
                    producers.put(endpoint, producer);
                }
                catch (Exception e) {
                    if (this.isIgnoreInvalidEndpoints()) {
                        LOG.info((Object)("Endpoint uri is invalid: " + recipient + ". This exception will be ignored."), (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
            MulticastProcessor mp = new MulticastProcessor(exchange.getContext(), processors, this.getAggregationStrategy(), this.isParallelProcessing(), this.getExecutorService(), false, this.isStopOnException());
            mp.process(exchange);
        }
        finally {
            for (Map.Entry entry : producers.entrySet()) {
                this.producerCache.releaseProducer((Endpoint)entry.getKey(), (Producer)entry.getValue());
            }
        }
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(this, this.camelContext);
            this.camelContext.addService(this.producerCache);
        }
        ServiceHelper.startService(this.producerCache);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

