/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Navigate;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteService
extends ServiceSupport {
    private static final Log LOG = LogFactory.getLog(RouteService.class);
    private final DefaultCamelContext camelContext;
    private final RouteDefinition routeDefinition;
    private final List<RouteContext> routeContexts;
    private final List<Route> routes;
    private final String id;
    private boolean removingRoutes;
    private final Map<Route, Consumer> inputs = new HashMap<Route, Consumer>();
    private final AtomicBoolean warmUpDone = new AtomicBoolean(false);

    public RouteService(DefaultCamelContext camelContext, RouteDefinition routeDefinition, List<RouteContext> routeContexts, List<Route> routes) {
        this.camelContext = camelContext;
        this.routeDefinition = routeDefinition;
        this.routeContexts = routeContexts;
        this.routes = routes;
        this.id = routeDefinition.idOrCreate(camelContext.getNodeIdFactory());
    }

    public String getId() {
        return this.id;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteContext> getRouteContexts() {
        return this.routeContexts;
    }

    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }

    public Collection<Route> getRoutes() {
        return this.routes;
    }

    public Map<Route, Consumer> getInputs() {
        return this.inputs;
    }

    @Deprecated
    public boolean isRemovingRoutes() {
        return this.removingRoutes;
    }

    @Deprecated
    public void setRemovingRoutes(boolean removingRoutes) {
        this.removingRoutes = removingRoutes;
    }

    public synchronized void warmUp() throws Exception {
        if (this.warmUpDone.compareAndSet(false, true)) {
            for (Route route : this.routes) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Starting route services: " + route));
                }
                List<Service> services = route.getServices();
                route.onStartingServices(services);
                LinkedHashSet<Service> list = new LinkedHashSet<Service>();
                for (Service service : services) {
                    RouteService.doGetChildServices(list, service);
                }
                ArrayList<Service> childServices = new ArrayList<Service>();
                for (Service service : list) {
                    if (service instanceof Consumer) {
                        this.inputs.put(route, (Consumer)service);
                        continue;
                    }
                    childServices.add(service);
                }
                this.startChildService(route, childServices);
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesAdd(this.routes);
            }
            this.camelContext.addRouteCollection(this.routes);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.warmUp();
        for (Route route : this.routes) {
            ServiceHelper.startService(route);
            EventHelper.notifyRouteStarted(this.camelContext, route);
        }
    }

    @Override
    protected void doStop() throws Exception {
        boolean isShutdownCamelContext = this.camelContext.isStopping();
        if (isShutdownCamelContext || this.isRemovingRoutes()) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesRemove(this.routes);
            }
        }
        for (Route route : this.routes) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Stopping route: " + route));
            }
            List<Service> services = route.getServices();
            LinkedHashSet<Service> list = new LinkedHashSet<Service>();
            for (Service service : services) {
                RouteService.doGetChildServices(list, service);
            }
            this.stopChildService(route, list, isShutdownCamelContext);
            if (isShutdownCamelContext) {
                ServiceHelper.stopAndShutdownService(route);
            } else {
                ServiceHelper.stopService(route);
            }
            EventHelper.notifyRouteStopped(this.camelContext, route);
        }
        this.camelContext.removeRouteCollection(this.routes);
        this.warmUpDone.set(false);
    }

    @Override
    protected void doShutdown() throws Exception {
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRoutesRemove(this.routes);
        }
        this.inputs.clear();
        this.warmUpDone.set(false);
    }

    @Override
    protected void doSuspend() throws Exception {
    }

    @Override
    protected void doResume() throws Exception {
    }

    protected void startChildService(Route route, List<Service> services) throws Exception {
        for (Service service : services) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceAdd(this.camelContext, service, route);
            }
            ServiceHelper.startService(service);
            this.addChildService(service);
        }
    }

    protected void stopChildService(Route route, Set<Service> services, boolean shutdown) throws Exception {
        for (Service service : services) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceRemove(this.camelContext, service, route);
            }
            if (shutdown) {
                ServiceHelper.stopAndShutdownService(service);
            } else {
                ServiceHelper.stopService(service);
            }
            this.removeChildService(service);
        }
    }

    private static void doGetChildServices(Set<Service> services, Service service) throws Exception {
        Navigate nav;
        services.add(service);
        if (service instanceof Navigate && (nav = (Navigate)((Object)service)).hasNext()) {
            List children = nav.next();
            for (Object child : children) {
                if (!(child instanceof Service)) continue;
                RouteService.doGetChildServices(services, (Service)child);
            }
        }
    }
}

