/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.OrderedComparator;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitOfWorkHelper {
    private UnitOfWorkHelper() {
    }

    public static void doneSynchronizations(Exchange exchange, List<Synchronization> synchronizations, Log log) {
        boolean failed = exchange.isFailed();
        if (synchronizations != null && !synchronizations.isEmpty()) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            Collections.sort(copy, new OrderedComparator());
            for (Synchronization synchronization : copy) {
                try {
                    if (failed) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Invoking synchronization.onFailure: " + synchronization + " with " + exchange));
                        }
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Invoking synchronization.onComplete: " + synchronization + " with " + exchange));
                    }
                    synchronization.onComplete(exchange);
                }
                catch (Throwable e) {
                    log.warn((Object)"Exception occurred during onCompletion. This exception will be ignored.", e);
                }
            }
        }
    }
}

