/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Attachments;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.OutHeaders;
import org.apache.camel.Properties;
import org.apache.camel.Property;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.AnnotationExpressionFactory;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInfo {
    private static final transient Logger LOG = LoggerFactory.getLogger(BeanInfo.class);
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private final CamelContext camelContext;
    private final Class<?> type;
    private final ParameterMappingStrategy strategy;
    private final MethodInfo defaultMethod;
    private Map<String, List<MethodInfo>> operations = new HashMap<String, List<MethodInfo>>();
    private List<MethodInfo> operationsWithBody = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithCustomAnnotation = new ArrayList<MethodInfo>();
    private List<MethodInfo> operationsWithHandlerAnnotation = new ArrayList<MethodInfo>();
    private Map<Method, MethodInfo> methodMap = new HashMap<Method, MethodInfo>();

    public BeanInfo(CamelContext camelContext, Class<?> type) {
        this(camelContext, type, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanInfo(CamelContext camelContext, Class<?> type, ParameterMappingStrategy strategy) {
        List<MethodInfo> methods;
        this.camelContext = camelContext;
        this.type = type;
        this.strategy = strategy;
        this.introspect(this.getType());
        MethodInfo method = null;
        if (this.operations.size() == 1 && (methods = this.operations.values().iterator().next()).size() == 1) {
            method = methods.get(0);
        }
        this.defaultMethod = method;
        this.operations = Collections.unmodifiableMap(this.operations);
        this.operationsWithBody = Collections.unmodifiableList(this.operationsWithBody);
        this.operationsWithCustomAnnotation = Collections.unmodifiableList(this.operationsWithCustomAnnotation);
        this.operationsWithHandlerAnnotation = Collections.unmodifiableList(this.operationsWithHandlerAnnotation);
        this.methodMap = Collections.unmodifiableMap(this.methodMap);
    }

    public Class<?> getType() {
        return this.type;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public static ParameterMappingStrategy createParameterMappingStrategy(CamelContext camelContext) {
        Registry registry = camelContext.getRegistry();
        ParameterMappingStrategy answer = registry.lookup("CamelBeanParameterMappingStrategy", ParameterMappingStrategy.class);
        if (answer == null) {
            answer = new DefaultParameterMappingStrategy();
        }
        return answer;
    }

    public MethodInvocation createInvocation(Method method, Object pojo, Exchange exchange) {
        MethodInfo methodInfo = this.introspect(this.type, method);
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    public MethodInvocation createInvocation(Object pojo, Exchange exchange) throws AmbiguousMethodCallException, MethodNotFoundException {
        MethodInfo methodInfo = null;
        String name = exchange.getIn().getHeader("CamelBeanMethodName", String.class);
        if (name != null) {
            if (this.hasMethod(name)) {
                List<MethodInfo> methods = this.getOperations(name);
                if (methods != null && methods.size() == 1) {
                    methodInfo = methods.get(0);
                } else {
                    methodInfo = this.chooseMethod(pojo, exchange, name);
                    if (methodInfo == null || !name.equals(methodInfo.getMethod().getName())) {
                        throw new AmbiguousMethodCallException(exchange, methods);
                    }
                }
            } else {
                throw new MethodNotFoundException(exchange, pojo, name);
            }
        }
        if (methodInfo == null) {
            methodInfo = this.chooseMethod(pojo, exchange, null);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethod;
        }
        if (methodInfo != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Chosen method to invoke: " + methodInfo + " on bean: " + pojo);
            }
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot find suitable method to invoke on bean: " + pojo);
        }
        return null;
    }

    protected void introspect(Class<?> clazz) {
        Method[] methods;
        clazz = BeanInfo.getTargetClass(clazz);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Introspecting class: " + clazz);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            boolean valid = this.isValidMethod(clazz, method);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Method:  " + method + " is valid: " + valid);
            }
            if (!valid) continue;
            this.introspect(clazz, method);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    protected MethodInfo introspect(Class<?> clazz, Method method) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Introspecting class: " + clazz + ", method: " + method);
        }
        String opName = method.getName();
        MethodInfo methodInfo = this.createMethodInfo(clazz, method);
        MethodInfo existingMethodInfo = this.overridesExistingMethod(methodInfo);
        if (existingMethodInfo != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("This method is already overridden in a subclass, so the method from the sub class is preferred: " + existingMethodInfo);
            }
            return existingMethodInfo;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding operation: " + opName + " for method: " + methodInfo);
        }
        if (this.hasMethod(opName)) {
            List<MethodInfo> existing = this.getOperations(opName);
            existing.add(methodInfo);
        } else {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            methods.add(methodInfo);
            this.operations.put(opName, methods);
        }
        if (methodInfo.hasCustomAnnotation()) {
            this.operationsWithCustomAnnotation.add(methodInfo);
        } else if (methodInfo.hasBodyParameter()) {
            this.operationsWithBody.add(methodInfo);
        }
        if (methodInfo.hasHandlerAnnotation()) {
            this.operationsWithHandlerAnnotation.add(methodInfo);
        }
        this.methodMap.put(method, methodInfo);
        return methodInfo;
    }

    public MethodInfo getMethodInfo(Method method) {
        Class<?> superclass;
        MethodInfo answer = this.methodMap.get(method);
        if (answer == null && this.type != Object.class && (superclass = this.type.getSuperclass()) != null && superclass != Object.class) {
            BeanInfo superBeanInfo = new BeanInfo(this.camelContext, superclass, this.strategy);
            return superBeanInfo.getMethodInfo(method);
        }
        return answer;
    }

    protected MethodInfo createMethodInfo(Class clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> bodyParameters = new ArrayList<ParameterInfo>();
        boolean hasCustomAnnotation = false;
        boolean hasHandlerAnnotation = ObjectHelper.hasAnnotation(method.getAnnotations(), Handler.class);
        int size = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: " + clazz + " method: " + method + " having " + size + " parameters");
        }
        for (int i = 0; i < size; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations);
            hasCustomAnnotation |= expression != null;
            ParameterInfo parameterInfo = new ParameterInfo(i, parameterType, parameterAnnotations, expression);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Parameter #" + i + ": " + parameterInfo);
            }
            parameters.add(parameterInfo);
            if (expression == null) {
                boolean bodyAnnotation = ObjectHelper.hasAnnotation(parameterAnnotations, Body.class);
                if (LOG.isTraceEnabled() && bodyAnnotation) {
                    LOG.trace("Parameter #" + i + " has @Body annotation");
                }
                hasCustomAnnotation |= bodyAnnotation;
                if (bodyParameters.isEmpty()) {
                    expression = Exchange.class.isAssignableFrom(parameterType) ? ExpressionBuilder.exchangeExpression() : ExpressionBuilder.mandatoryBodyExpression(parameterType, true);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Parameter #" + i + " is the body parameter using expression " + expression);
                    }
                    parameterInfo.setExpression(expression);
                    bodyParameters.add(parameterInfo);
                }
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Parameter #" + i + " has parameter info: " + parameterInfo);
        }
        return new MethodInfo(this.camelContext, clazz, method, parameters, bodyParameters, hasCustomAnnotation, hasHandlerAnnotation);
    }

    protected MethodInfo chooseMethod(Object pojo, Exchange exchange, String name) throws AmbiguousMethodCallException {
        ArrayList<MethodInfo> localOperationsWithBody = new ArrayList<MethodInfo>(this.operationsWithBody);
        ArrayList<MethodInfo> localOperationsWithCustomAnnotation = new ArrayList<MethodInfo>(this.operationsWithCustomAnnotation);
        ArrayList<MethodInfo> localOperationsWithHandlerAnnotation = new ArrayList<MethodInfo>(this.operationsWithHandlerAnnotation);
        if (name != null) {
            BeanInfo.removeNonMatchingMethods(localOperationsWithHandlerAnnotation, name);
            BeanInfo.removeNonMatchingMethods(localOperationsWithCustomAnnotation, name);
            BeanInfo.removeNonMatchingMethods(localOperationsWithBody, name);
        } else {
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithHandlerAnnotation);
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithCustomAnnotation);
            BeanInfo.removeAllSetterOrGetterMethods(localOperationsWithBody);
        }
        if (localOperationsWithHandlerAnnotation.size() > 1) {
            throw new AmbiguousMethodCallException(exchange, localOperationsWithHandlerAnnotation);
        }
        if (localOperationsWithHandlerAnnotation.size() == 1) {
            return (MethodInfo)localOperationsWithHandlerAnnotation.get(0);
        }
        if (localOperationsWithCustomAnnotation.size() == 1) {
            return (MethodInfo)localOperationsWithCustomAnnotation.get(0);
        }
        if (localOperationsWithBody.size() == 1) {
            return (MethodInfo)localOperationsWithBody.get(0);
        }
        ArrayList<MethodInfo> possibleOperations = new ArrayList<MethodInfo>();
        possibleOperations.addAll(localOperationsWithBody);
        possibleOperations.addAll(localOperationsWithCustomAnnotation);
        if (!possibleOperations.isEmpty()) {
            MethodInfo answer = this.chooseMethodWithMatchingBody(exchange, possibleOperations, localOperationsWithCustomAnnotation);
            if (answer == null) {
                throw new AmbiguousMethodCallException(exchange, possibleOperations);
            }
            return answer;
        }
        return null;
    }

    private MethodInfo chooseMethodWithMatchingBody(Exchange exchange, Collection<MethodInfo> operationList, List<MethodInfo> operationsWithCustomAnnotation) throws AmbiguousMethodCallException {
        Message in = exchange.getIn();
        Object body = in.getBody();
        if (body != null) {
            Class<?> bodyType = body.getClass();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Matching for method with a single parameter that matches type: " + bodyType.getCanonicalName());
            }
            ArrayList<MethodInfo> possibles = new ArrayList<MethodInfo>();
            ArrayList<MethodInfo> possiblesWithException = new ArrayList<MethodInfo>();
            for (MethodInfo methodInfo : operationList) {
                boolean out = exchange.getPattern().isOutCapable();
                if (out && methodInfo.isReturnTypeVoid() || !methodInfo.bodyParameterMatches(bodyType)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found a possible method: " + methodInfo);
                }
                if (methodInfo.hasExceptionParameter()) {
                    possiblesWithException.add(methodInfo);
                    continue;
                }
                possibles.add(methodInfo);
            }
            return this.chooseBestPossibleMethodInfo(exchange, operationList, body, possibles, possiblesWithException, operationsWithCustomAnnotation);
        }
        return null;
    }

    private MethodInfo chooseBestPossibleMethodInfo(Exchange exchange, Collection<MethodInfo> operationList, Object body, List<MethodInfo> possibles, List<MethodInfo> possiblesWithException, List<MethodInfo> possibleWithCustomAnnotation) throws AmbiguousMethodCallException {
        Exception exception = ExpressionBuilder.exchangeExceptionExpression().evaluate(exchange, Exception.class);
        if (exception != null && possiblesWithException.size() == 1) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Exchange has exception set so we prefer method that also has exception as parameter");
            }
            return possiblesWithException.get(0);
        }
        if (possibles.size() == 1) {
            return possibles.get(0);
        }
        if (possibles.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No possible methods so now trying to convert body to parameter types");
            }
            Object newBody = null;
            MethodInfo matched = null;
            int matchCounter = 0;
            for (MethodInfo methodInfo : operationList) {
                if (methodInfo.getBodyParameterType().isInstance(body)) {
                    return methodInfo;
                }
                Object value = ExchangeHelper.convertToType(exchange, methodInfo.getBodyParameterType(), body);
                if (value == null) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Converted body from: " + body.getClass().getCanonicalName() + "to: " + methodInfo.getBodyParameterType().getCanonicalName());
                }
                ++matchCounter;
                newBody = value;
                matched = methodInfo;
            }
            if (matchCounter > 1) {
                throw new AmbiguousMethodCallException(exchange, Arrays.asList(matched, matched));
            }
            if (matched != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Setting converted body: " + body);
                }
                Message in = exchange.getIn();
                in.setBody(newBody);
                return matched;
            }
        } else {
            if (possibleWithCustomAnnotation.size() == 1) {
                MethodInfo answer = possibleWithCustomAnnotation.get(0);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("There are only one method with annotations so we choose it: " + answer);
                }
                return answer;
            }
            return this.chooseMethodWithCustomAnnotations(exchange, possibles);
        }
        return null;
    }

    protected boolean isValidMethod(Class<?> clazz, Method method) {
        for (Method excluded : EXCLUDED_METHODS) {
            if (!ObjectHelper.isOverridingMethod(excluded, method)) continue;
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        return (method.getReturnType() == null || !Exchange.class.isAssignableFrom(method.getReturnType())) && !method.isBridge();
    }

    private MethodInfo overridesExistingMethod(MethodInfo methodInfo) {
        for (MethodInfo info : this.methodMap.values()) {
            Method target;
            Method source = info.getMethod();
            boolean override = ObjectHelper.isOverridingMethod(source, target = methodInfo.getMethod());
            if (!override) continue;
            return info;
        }
        return null;
    }

    private MethodInfo chooseMethodWithCustomAnnotations(Exchange exchange, Collection<MethodInfo> possibles) throws AmbiguousMethodCallException {
        MethodInfo chosen = null;
        for (MethodInfo possible : possibles) {
            if (!possible.hasCustomAnnotation()) continue;
            if (chosen != null) {
                chosen = null;
                break;
            }
            chosen = possible;
        }
        if (chosen != null) {
            return chosen;
        }
        throw new AmbiguousMethodCallException(exchange, possibles);
    }

    private Expression createParameterUnmarshalExpression(Class<?> clazz, Method method, Class<?> parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    private Expression createParameterUnmarshalExpressionForAnnotation(Class<?> clazz, Method method, Class<?> parameterType, Annotation annotation) {
        if (annotation instanceof Attachments) {
            return ExpressionBuilder.attachmentsExpression();
        }
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return ExpressionBuilder.propertyExpression(propertyAnnotation.value());
        }
        if (annotation instanceof Properties) {
            return ExpressionBuilder.propertiesExpression();
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression(headerAnnotation.value());
        }
        if (annotation instanceof Headers) {
            return ExpressionBuilder.headersExpression();
        }
        if (annotation instanceof OutHeaders) {
            return ExpressionBuilder.outHeadersExpression();
        }
        if (annotation instanceof ExchangeException) {
            return ExpressionBuilder.exchangeExceptionExpression(CastUtils.cast(parameterType, Exception.class));
        }
        LanguageAnnotation languageAnnotation = annotation.annotationType().getAnnotation(LanguageAnnotation.class);
        if (languageAnnotation != null) {
            Class<?> type = languageAnnotation.factory();
            Object object = this.camelContext.getInjector().newInstance(type);
            if (object instanceof AnnotationExpressionFactory) {
                AnnotationExpressionFactory expressionFactory = (AnnotationExpressionFactory)object;
                return expressionFactory.createExpression(this.camelContext, annotation, languageAnnotation, parameterType);
            }
            LOG.warn("Ignoring bad annotation: " + languageAnnotation + "on method: " + method + " which declares a factory: " + type.getName() + " which does not implement " + AnnotationExpressionFactory.class.getName());
        }
        return null;
    }

    private static void removeAllSetterOrGetterMethods(List<MethodInfo> methods) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            if (IntrospectionSupport.isGetter(info.getMethod())) {
                it.remove();
                continue;
            }
            if (!IntrospectionSupport.isSetter(info.getMethod())) continue;
            it.remove();
        }
    }

    private static void removeNonMatchingMethods(List<MethodInfo> methods, String name) {
        Iterator<MethodInfo> it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = it.next();
            if (name.equals(info.getMethod().getName())) continue;
            it.remove();
        }
    }

    private static Class<?> getTargetClass(Class<?> clazz) {
        Class<?> superClass;
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public boolean hasMethod(String methodName) {
        return this.getOperations(methodName) != null;
    }

    public List<MethodInfo> getMethods() {
        if (this.operations.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (List<MethodInfo> col : this.operations.values()) {
            methods.addAll(col);
        }
        Collections.sort(methods, new Comparator<MethodInfo>(){

            @Override
            public int compare(MethodInfo o1, MethodInfo o2) {
                return o1.getMethod().getName().compareTo(o2.getMethod().getName());
            }
        });
        return methods;
    }

    private List<MethodInfo> getOperations(String methodName) {
        List<MethodInfo> answer = this.operations.get(methodName);
        if (answer != null) {
            return answer;
        }
        for (Method method : this.methodMap.keySet()) {
            String shorthandMethodName;
            if (!IntrospectionSupport.isGetter(method) || !methodName.equals(shorthandMethodName = IntrospectionSupport.getGetterShorthandName(method))) continue;
            return this.operations.get(method.getName());
        }
        return null;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
    }
}

