/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultPollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledPollConsumer
extends DefaultConsumer
implements Runnable,
SuspendableService {
    private static final transient Logger LOG = LoggerFactory.getLogger(ScheduledPollConsumer.class);
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay;
    private PollingConsumerPollStrategy pollStrategy = new DefaultPollingConsumerPollStrategy();

    public ScheduledPollConsumer(DefaultEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.executor = endpoint.getCamelContext().getExecutorServiceStrategy().newScheduledThreadPool(this, endpoint.getEndpointUri(), 1);
        ObjectHelper.notNull(this.executor, "executor");
    }

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor);
        this.executor = executor;
        ObjectHelper.notNull(executor, "executor");
    }

    @Override
    public void run() {
        if (this.isSuspended()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cannot start to poll: " + this.getEndpoint() + " as its suspended");
            }
            return;
        }
        int retryCounter = -1;
        boolean done = false;
        while (!done) {
            try {
                done = true;
                if (this.isPollAllowed()) {
                    boolean begin;
                    if (retryCounter == -1) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Starting to poll: " + this.getEndpoint());
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Retrying attempt " + retryCounter + " to poll: " + this.getEndpoint());
                    }
                    if (begin = this.pollStrategy.begin(this, this.getEndpoint())) {
                        ++retryCounter;
                        int polledMessages = this.poll();
                        this.pollStrategy.commit(this, this.getEndpoint(), polledMessages);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot begin polling as pollStrategy returned false: " + this.pollStrategy);
                    }
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Finished polling: " + this.getEndpoint());
            }
            catch (Exception e) {
                try {
                    boolean retry = this.pollStrategy.rollback(this, this.getEndpoint(), retryCounter, e);
                    if (!retry) continue;
                    done = false;
                }
                catch (Throwable t) {
                    this.getExceptionHandler().handleException("Consumer " + this + " failed polling endpoint: " + this.getEndpoint().getEndpointUri() + ". Will try again at next poll", t);
                    done = true;
                }
            }
            catch (Throwable t) {
                this.getExceptionHandler().handleException("Consumer " + this + " failed polling endpoint: " + this.getEndpoint().getEndpointUri() + ". Will try again at next poll", t);
                done = true;
            }
        }
    }

    protected boolean isPollAllowed() {
        return this.isRunAllowed() && !this.isSuspended();
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    protected abstract int poll() throws Exception;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.isUseFixedDelay()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling poll (fixed delay) with initialDelay: " + this.getInitialDelay() + ", delay: " + this.getDelay() + " (" + this.getTimeUnit().name().toLowerCase() + ") for: " + this.getEndpoint());
            }
            this.future = this.executor.scheduleWithFixedDelay(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling poll (fixed rate) with initialDelay: " + this.getInitialDelay() + ", delay: " + this.getDelay() + " (" + this.getTimeUnit().name().toLowerCase() + ") for: " + this.getEndpoint());
            }
            this.future = this.executor.scheduleAtFixedRate(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(false);
        }
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
    }
}

