/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

@XmlRootElement(name="split")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SplitDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<SplitDefinition> {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean streaming;
    @XmlAttribute
    private Boolean stopOnException;
    @XmlAttribute
    private Long timeout;

    public SplitDefinition() {
    }

    public SplitDefinition(Expression expression) {
        super(expression);
    }

    public SplitDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public String toString() {
        return "Split[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "split";
    }

    @Override
    public String getLabel() {
        return "split";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        this.aggregationStrategy = this.createAggregationStrategy(routeContext);
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "Split", this);
        if (this.isParallelProcessing() && this.executorService == null) {
            this.executorService = routeContext.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "Split");
        }
        if (this.getTimeout() > 0L && !this.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        Expression exp = this.getExpression().createExpression(routeContext);
        return new Splitter(routeContext.getCamelContext(), exp, childProcessor, this.aggregationStrategy, this.isParallelProcessing(), this.executorService, this.isStreaming(), this.isStopOnException(), this.getTimeout());
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            strategy = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.strategyRef, AggregationStrategy.class);
        }
        return strategy;
    }

    public ExpressionClause<SplitDefinition> expression() {
        return ExpressionClause.createAndSetExpression(this);
    }

    public SplitDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public SplitDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public SplitDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public SplitDefinition streaming() {
        this.setStreaming(true);
        return this;
    }

    public SplitDefinition stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    @Override
    public SplitDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public SplitDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public SplitDefinition timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null && this.parallelProcessing != false;
    }

    public Boolean getStreaming() {
        return this.streaming;
    }

    public void setStreaming(Boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isStreaming() {
        return this.streaming != null && this.streaming != false;
    }

    public Boolean getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public Boolean isStopOnException() {
        return this.stopOnException != null && this.stopOnException != false;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Long getTimeout() {
        return this.timeout != null ? this.timeout : 0L;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }
}

