/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class FailOverLoadBalancer
extends LoadBalancerSupport
implements Traceable {
    private final List<Class<?>> exceptions;
    private boolean roundRobin;
    private int maximumFailoverAttempts = -1;
    private final AtomicInteger counter = new AtomicInteger(-1);

    public FailOverLoadBalancer() {
        this.exceptions = null;
    }

    public FailOverLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
        for (Class<?> type : exceptions) {
            if (ObjectHelper.isAssignableFrom(Throwable.class, type)) continue;
            throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
        }
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public int getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(int maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    protected boolean shouldFailOver(Exchange exchange) {
        boolean answer = false;
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                answer = true;
            } else {
                for (Class<?> exception : this.exceptions) {
                    if (exchange.getException(exception) == null) continue;
                    answer = true;
                    break;
                }
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Should failover: " + answer + " for exchangeId: " + exchange.getExchangeId());
        }
        return answer;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        List<Processor> processors = this.getProcessors();
        AtomicInteger index = new AtomicInteger();
        AtomicInteger attempts = new AtomicInteger();
        boolean first = true;
        if (this.isRoundRobin()) {
            if (this.counter.incrementAndGet() >= processors.size()) {
                this.counter.set(0);
            }
            index.set(this.counter.get());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Failover starting with endpoint index " + index);
        }
        while (first || this.shouldFailOver(exchange)) {
            if (!first) {
                attempts.incrementAndGet();
                if (this.maximumFailoverAttempts > -1 && attempts.get() > this.maximumFailoverAttempts) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Braking out of failover after " + attempts + " failover attempts");
                    break;
                }
                index.incrementAndGet();
                this.counter.incrementAndGet();
            } else {
                first = false;
            }
            if (index.get() >= processors.size()) {
                if (this.isRoundRobin()) {
                    this.log.trace("Failover is round robin enabled and therefore starting from the first endpoint");
                    index.set(0);
                    this.counter.set(0);
                } else {
                    this.log.trace("Braking out of failover as we reach the end of endpoints to use for failover");
                    break;
                }
            }
            this.prepareExchangeForFailover(exchange);
            Processor processor = processors.get(index.get());
            boolean sync = this.processExchange(processor, exchange, attempts, index, callback, processors);
            if (!sync) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously");
                }
                return false;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed synchronously");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failover complete for exchangeId: " + exchange.getExchangeId() + " >>> " + exchange);
        }
        callback.done(true);
        return true;
    }

    protected void prepareExchangeForFailover(Exchange exchange) {
        if (exchange.getException() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failover due " + exchange.getException().getMessage() + " for exchangeId: " + exchange.getExchangeId());
            }
            exchange.setException(null);
        }
        exchange.setProperty("CamelErrorHandlerHandled", null);
        exchange.setProperty("CamelFailureHandled", null);
        exchange.setProperty("CamelExceptionCaught", null);
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
        exchange.getIn().removeHeader("CamelRedeliveryMaxCounter");
    }

    private boolean processExchange(Processor processor, Exchange exchange, AtomicInteger attempts, AtomicInteger index, AsyncCallback callback, List<Processor> processors) {
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process " + exchange);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing failover at attempt " + attempts + " for " + exchange);
        }
        AsyncProcessor albp = AsyncProcessorTypeConverter.convert(processor);
        return AsyncProcessorHelper.process(albp, exchange, new FailOverAsyncCallback(exchange, attempts, index, callback, processors));
    }

    public String toString() {
        return "FailoverLoadBalancer[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "failover";
    }

    private final class FailOverAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AtomicInteger attempts;
        private final AtomicInteger index;
        private final AsyncCallback callback;
        private final List<Processor> processors;

        private FailOverAsyncCallback(Exchange exchange, AtomicInteger attempts, AtomicInteger index, AsyncCallback callback, List<Processor> processors) {
            this.exchange = exchange;
            this.attempts = attempts;
            this.index = index;
            this.callback = callback;
            this.processors = processors;
        }

        @Override
        public void done(boolean doneSync) {
            if (doneSync) {
                return;
            }
            while (FailOverLoadBalancer.this.shouldFailOver(this.exchange)) {
                this.attempts.incrementAndGet();
                if (FailOverLoadBalancer.this.maximumFailoverAttempts > -1 && this.attempts.get() > FailOverLoadBalancer.this.maximumFailoverAttempts) {
                    if (!FailOverLoadBalancer.this.log.isTraceEnabled()) break;
                    FailOverLoadBalancer.this.log.trace("Braking out of failover after " + this.attempts + " failover attempts");
                    break;
                }
                this.index.incrementAndGet();
                FailOverLoadBalancer.this.counter.incrementAndGet();
                if (this.index.get() >= this.processors.size()) {
                    if (FailOverLoadBalancer.this.isRoundRobin()) {
                        FailOverLoadBalancer.this.log.trace("Failover is round robin enabled and therefore starting from the first endpoint");
                        this.index.set(0);
                        FailOverLoadBalancer.this.counter.set(0);
                    } else {
                        FailOverLoadBalancer.this.log.trace("Braking out of failover as we reach the end of endpoints to use for failover");
                        break;
                    }
                }
                FailOverLoadBalancer.this.prepareExchangeForFailover(this.exchange);
                Processor processor = this.processors.get(this.index.get());
                doneSync = FailOverLoadBalancer.this.processExchange(processor, this.exchange, this.attempts, this.index, this.callback, this.processors);
                if (doneSync) continue;
                if (FailOverLoadBalancer.this.log.isTraceEnabled()) {
                    FailOverLoadBalancer.this.log.trace("Processing exchangeId: " + this.exchange.getExchangeId() + " is continued being processed asynchronously");
                }
                return;
            }
            if (FailOverLoadBalancer.this.log.isDebugEnabled()) {
                FailOverLoadBalancer.this.log.debug("Failover complete for exchangeId: " + this.exchange.getExchangeId() + " >>> " + this.exchange);
            }
            this.callback.done(false);
        }
    }
}

